/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.io.LineReader;
import ch.epfl.bbp.triechar.TrieId;
import ch.epfl.bbp.uima.utils.Preconditions;
import de.julielab.jules.types.Header;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class OneDocPerLineIdsReader
extends JCasCollectionReader_ImplBase {
    @ConfigurationParameter(name="inputFile", description="path to the corpus file")
    protected String inputDir;
    public static final String PARAM_VOCABULARY_INPUT_FILE = "vocabularyInputFile";
    @ConfigurationParameter(name="vocabularyInputFile", mandatory=true)
    private String vocabularyInputFile;
    private int nextPmid;
    private int lastPmid;
    private String nextTxt = "";
    private Iterator<String> textFileReader;
    private TrieId vocab;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        Preconditions.checkFileExists(this.inputDir);
        Preconditions.checkFileExists(this.vocabularyInputFile);
        try {
            this.vocab = TrieId.fromIdsFile((InputStream)new FileInputStream(new File(this.vocabularyInputFile)));
            this.textFileReader = new LineReader((InputStream)new FileInputStream(this.inputDir)).iterator();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        String line = this.textFileReader.next();
        Object io = null;
        Header header = new Header(jcas);
        header.setDocId("" + this.nextPmid);
        header.addToIndexes();
        jcas.setDocumentText(this.nextTxt);
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.textFileReader.hasNext();
    }

    public Progress[] getProgress() {
        return null;
    }
}

