/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.ResourceHelper;
import ch.epfl.bbp.uima.io.DirectoryIterator;
import ch.epfl.bbp.uima.utils.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdaCReader
extends JCasCollectionReader_ImplBase {
    protected static final Logger LOG = LoggerFactory.getLogger(LdaCReader.class);
    @ConfigurationParameter(name="inputDirectory", description="path to a directory containing pdfs, or path to a zip file containing pdfs (make sure it does not contain other file formats)")
    protected String inputDir;
    @ConfigurationParameter(name="directoryIterator", defaultValue={"DefaultDirectoryIterator"}, description="the directoryIterator to use. E.g. DefaultDirectoryIterator, ZipDirectoryIterator, LargeDirectoryIterator")
    protected String directoryIterator;
    @ConfigurationParameter(name="isRecursive", defaultValue={"false"})
    protected boolean isRecursive;
    @ConfigurationParameter(name="fileExtensionFilter", defaultValue={"null"}, description="a filter on file extension")
    protected String fileExtensionFilter;
    protected Iterator<File> fileIterator;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            File dir = ResourceHelper.getFile((String)this.inputDir);
            Preconditions.checkFileExists(dir);
            if (this.fileExtensionFilter.equals("null")) {
                this.fileExtensionFilter = null;
            }
            this.fileIterator = DirectoryIterator.get(this.directoryIterator, dir, this.fileExtensionFilter, this.isRecursive);
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException("no_resource_for_parameters", new Object[]{this.inputDir});
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.fileIterator.hasNext();
    }

    public Progress[] getProgress() {
        return null;
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
    }
}

