/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.io.LineReader;
import com.google.common.base.Preconditions;
import de.julielab.jules.types.Header;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class FromFilelistReader
extends JCasCollectionReader_ImplBase {
    @ConfigurationParameter(name="inputFile", description="path to a txt file containing a list of file paths, one on each line. Each line is on the format {doc_id}\t{path}")
    protected String fileList;
    @ConfigurationParameter(name="pathPrefix", mandatory=false, description="prefix (=root path) to all files, leave it out for no prefix")
    protected String pathPrefix;
    @ConfigurationParameter(name="format", mandatory=false, description="if true, then format is just the path, and the file name is the pubmed id")
    protected boolean formatWithImplicitPmId;
    private Iterator<String> lineIt;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            Preconditions.checkArgument((boolean)new File(this.fileList).exists(), (Object)("no input file at " + this.fileList));
            this.lineIt = new LineReader((InputStream)new FileInputStream(this.fileList)).iterator();
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        String line = this.lineIt.next().trim();
        String docId = null;
        String source = null;
        if (this.formatWithImplicitPmId) {
            source = this.pathPrefix == null ? line : this.pathPrefix + line;
            docId = FilenameUtils.removeExtension((String)new File(line).getName());
        } else {
            String[] nextFile = line.split("\t");
            Preconditions.checkArgument((nextFile.length == 2 ? 1 : 0) != 0, (Object)("format is {doc_id}\\t{path}, found: '" + line + "'"));
            docId = nextFile[0];
            source = this.pathPrefix == null ? nextFile[1] : this.pathPrefix + nextFile[1];
        }
        Preconditions.checkArgument((boolean)new File(source).exists(), (Object)("no file at " + source));
        Header header = new Header(jcas);
        header.setDocId(docId);
        header.setSource(source);
        header.addToIndexes();
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.lineIt.hasNext();
    }

    public Progress[] getProgress() {
        return null;
    }
}

