/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.Progress;

public class AggregateCollectionReader
extends CollectionReader_ImplBase {
    private Iterator<CollectionReader> readerIterator;
    private List<CollectionReader> readers;
    private CollectionReader currentReader;

    public AggregateCollectionReader(List<CollectionReader> readers, TypeSystemDescription tsd) {
        try {
            CollectionReaderDescription crd = CollectionReaderFactory.createReaderDescription(AggregateCollectionReader.class, (TypeSystemDescription)tsd, (Object[])new Object[0]);
            ResourceMetaData metaData = crd.getMetaData();
            ConfigurationParameterSettings paramSettings = metaData.getConfigurationParameterSettings();
            HashMap<String, ConfigurationParameterSettings> additionalParameters = new HashMap<String, ConfigurationParameterSettings>();
            additionalParameters.put("CONFIG_PARAM_SETTINGS", paramSettings);
            this.initialize((ResourceSpecifier)crd, additionalParameters);
            this.readers = readers;
            this.readerIterator = this.readers.iterator();
            this.currentReader = this.readerIterator.next();
        }
        catch (ResourceInitializationException rie) {
            throw new RuntimeException(rie);
        }
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        this.currentReader.getNext(aCAS);
    }

    public void close() throws IOException {
        for (CollectionReader reader : this.readers) {
            reader.close();
        }
    }

    public Progress[] getProgress() {
        return new Progress[0];
    }

    public boolean hasNext() throws IOException, CollectionException {
        if (this.currentReader.hasNext()) {
            return true;
        }
        if (this.readerIterator.hasNext()) {
            this.currentReader = this.readerIterator.next();
            return this.hasNext();
        }
        return false;
    }
}

