/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.annotationviewer;

import ch.epfl.bbp.ResourceHelper;
import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.annotationviewer.BlueAnnotationViewer;
import de.julielab.jules.types.Header;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(outputs={})
public class BlueAnnotationViewerAnnotator
extends JCasAnnotator_ImplBase {
    Logger LOG = LoggerFactory.getLogger(BlueAnnotationViewerAnnotator.class);
    @ConfigurationParameter(name="outputDir", defaultValue={"annotationViewer/"})
    private String outputDir;
    public static final String STYLE_MAP = "styleMap";
    @ConfigurationParameter(name="styleMap", defaultValue={"viewer/blueStyleMap.xml"})
    private String styleMap;
    private BlueAnnotationViewer annotationViewer;
    private File styleMapFile;
    private int i = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.styleMapFile = ResourceHelper.getFile((String)this.styleMap);
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException("no_resource_for_parameters", new Object[]{this.styleMap});
        }
        this.annotationViewer = new BlueAnnotationViewer(new File("/tmp"));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (BlueCasUtil.isEmptyText(jCas)) {
            this.LOG.warn("skipping document, text is empty");
        } else {
            File outputFile;
            try {
                Header header = (Header)JCasUtil.selectSingle((JCas)jCas, Header.class);
                if (header.getDocId() == null || header.getDocId().equals("null")) {
                    String generatedFilename = this.outputDir + "unkn" + this.i++;
                    this.LOG.warn("no docId found in CAS, using " + generatedFilename);
                    outputFile = new File(generatedFilename);
                } else {
                    outputFile = new File(this.outputDir + header.getDocId());
                }
            }
            catch (Exception e) {
                String generatedFilename = this.outputDir + "unkn" + this.i++;
                this.LOG.warn("no docId found in CAS, using " + generatedFilename);
                outputFile = new File(generatedFilename);
            }
            this.LOG.debug("writing AnnotationViewer in " + outputFile.getAbsolutePath());
            try {
                FileUtils.forceMkdir((File)outputFile);
                this.annotationViewer.createHtml(jCas, jCas.getTypeSystem(), this.styleMapFile, outputFile);
            }
            catch (IOException e) {
                this.LOG.warn("error createHtml", (Throwable)e);
            }
        }
    }

    public static AnalysisEngine getAE() throws FileNotFoundException, ResourceInitializationException {
        return AnalysisEngineFactory.createEngine((AnalysisEngineDescription)BlueAnnotationViewerAnnotator.getAED(), (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getAED() throws FileNotFoundException, ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(BlueAnnotationViewerAnnotator.class, (Object[])new Object[0]);
    }
}

