/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.serialization;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.utils.StructuredDirectory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryCasWriter
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(BinaryCasWriter.class);
    public static final String EXTENTION_GZ = "gz";
    @ConfigurationParameter(name="outputDir")
    private String outputDir;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int docId = BlueCasUtil.getHeaderIntDocId(jCas);
        try {
            File file = new File(this.outputDir + "/" + StructuredDirectory.getFilePath(docId, EXTENTION_GZ));
            if (file.getParentFile() != null) {
                FileUtils.forceMkdir((File)file.getParentFile());
            }
            BinaryCasWriter.serialize(jCas, file);
        }
        catch (Exception e) {
            LOG.error("could not serialize pmId " + docId, (Throwable)e);
        }
    }

    public static void serialize(JCas jCas, File file) throws FileNotFoundException, IOException, CASRuntimeException, ResourceInitializationException {
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(file));
        BinaryCasWriter.writeTypeSystem(jCas, os);
        Serialization.serializeWithCompression((CAS)jCas.getCas(), (Object)os, (TypeSystem)jCas.getTypeSystem());
        ((OutputStream)os).close();
    }

    private static void writeTypeSystem(JCas aJCas, OutputStream aOS) throws IOException {
        ObjectOutputStream typeOS = new ObjectOutputStream(aOS);
        CASMgrSerializer casMgrSerializer = Serialization.serializeCASMgr((CASMgr)aJCas.getCasImpl());
        typeOS.writeObject(casMgrSerializer);
        typeOS.flush();
    }
}

