/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.serialization;

import ch.epfl.bbp.uima.cr.AbstractFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class BinaryCasReader
extends AbstractFileReader {
    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.fileExtensionFilter = "gz";
        this.isRecursive = true;
        super.initialize(context);
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        File file = (File)this.fileIterator.next();
        try {
            BinaryCasReader.deserialize(file, jCas);
        }
        catch (Exception e) {
            LOG.error("could not read serialized cas at " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public static void deserialize(File file, JCas jCas) throws IOException, ClassNotFoundException, ResourceInitializationException {
        GZIPInputStream dis = new GZIPInputStream(new FileInputStream(file));
        TypeSystemImpl ts = null;
        ObjectInputStream ois = new ObjectInputStream(dis);
        CASMgrSerializer casMgrSerializer = (CASMgrSerializer)ois.readObject();
        ts = casMgrSerializer.getTypeSystem();
        ts.commit();
        Serialization.deserializeCAS((CAS)jCas.getCas(), (InputStream)dis, (TypeSystem)ts, null);
        ((InputStream)dis).close();
    }
}

