/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.types.Cooccurrence;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Cooccurrence"})
public class FilterCoocurrencesInLongSentences
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="enclosingScope", defaultValue={"de.julielab.jules.types.Sentence"}, mandatory=false, description="the enclosing scope to iterate on and extract co-occurrence from. Defaults to sentences")
    protected String enclosingScopeStr;
    protected Class<? extends Annotation> enclosingScope;
    public static final String PARAM_MAXIMUM_SCOPE_LENGTH = "maximumEnclosingScopeLength";
    @ConfigurationParameter(name="maximumEnclosingScopeLength", defaultValue={"1000"}, mandatory=false, description="If the enclosing scope is longer than this value, all co-occurrences are filtered out")
    protected int maximumEnclosingScopeLength;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.enclosingScope = Class.forName(this.enclosingScopeStr);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        LinkedList toRemove = Lists.newLinkedList();
        Map enclosingScopeWithCoocurences = JCasUtil.indexCovered((JCas)jCas, this.enclosingScope, Cooccurrence.class);
        for (Annotation es : JCasUtil.select((JCas)jCas, this.enclosingScope)) {
            if (es.getCoveredText().length() <= this.maximumEnclosingScopeLength || !enclosingScopeWithCoocurences.containsKey(es)) continue;
            toRemove.addAll((Collection)enclosingScopeWithCoocurences.get(es));
        }
        Cooccurrence[] array = toRemove.toArray(new Cooccurrence[toRemove.size()]);
        for (int i = 0; i < array.length; ++i) {
            array[i].removeFromIndexes();
        }
    }
}

