/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.types.Cooccurrence;
import com.google.common.collect.Lists;
import de.julielab.jules.types.Sentence;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Cooccurrence"})
public class FilterCoocurrencesByNot
extends JCasAnnotator_ImplBase {
    protected static Logger LOG = LoggerFactory.getLogger(FilterCoocurrencesByNot.class);
    private static final Pattern NOT = Pattern.compile("\\Wnot?\\W");

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        LinkedList toRemove = Lists.newLinkedList();
        for (Map.Entry sentenceWithCooc : JCasUtil.indexCovered((JCas)jCas, Sentence.class, Cooccurrence.class).entrySet()) {
            String sText = ((Sentence)sentenceWithCooc.getKey()).getCoveredText().toLowerCase();
            if (!NOT.matcher(sText).find()) continue;
            toRemove.addAll((Collection)sentenceWithCooc.getValue());
        }
        Cooccurrence[] array = toRemove.toArray(new Cooccurrence[toRemove.size()]);
        for (int i = 0; i < array.length; ++i) {
            array[i].removeFromIndexes();
        }
    }
}

