/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.Cooccurrence;
import ch.epfl.bbp.uima.validation.Comparator;
import ch.epfl.bbp.uima.validation.TestEvaluator;
import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@OperationalProperties(multipleDeploymentAllowed=false)
@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Cooccurrence"})
public class CooccurrencesEvaluationAnnotator
extends JCasAnnotator_ImplBase {
    private TestEvaluator<Annotation, Annotation> evaluator;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.evaluator = CooccurrencesEvaluationAnnotator.getEvaluator();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCas systemView;
        JCas goldView;
        String pmId = BlueCasUtil.getHeaderDocId(jCas);
        CooccurrencesEvaluationAnnotator.print("pmId " + pmId);
        try {
            goldView = jCas.getView("view_gold");
            systemView = jCas.getView("_InitialView");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        Collection goldAnnot = JCasUtil.select((JCas)goldView, Cooccurrence.class);
        Collection systAnnot = JCasUtil.select((JCas)systemView, Cooccurrence.class);
        CooccurrencesEvaluationAnnotator.print("comparing #gold:" + goldAnnot.size() + " #sys:" + systAnnot.size());
        CooccurrencesEvaluationAnnotator.print(this.evaluator.add(goldAnnot, systAnnot, pmId));
    }

    private static void print(String msg) {
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        System.out.println(this.evaluator.compare());
    }

    public static <A extends Annotation, B extends Annotation> TestEvaluator<A, B> getEvaluator() {
        Comparator simpleComparator = new Comparator<A, B>(){

            @Override
            public boolean areTheSame(A _gold, B _system) {
                Cooccurrence gold = (Cooccurrence)_gold;
                Cooccurrence system = (Cooccurrence)_system;
                return CooccurrencesEvaluationAnnotator.areTheSame(gold, system);
            }
        };
        return new TestEvaluator(simpleComparator);
    }

    public static boolean areTheSame(Cooccurrence gold, Cooccurrence system) {
        return BlueCasUtil.haveSameBeginEnd(gold.getFirstEntity(), system.getFirstEntity()) && BlueCasUtil.haveSameBeginEnd(gold.getFirstEntity(), system.getFirstEntity()) || BlueCasUtil.haveSameBeginEnd(gold.getSecondEntity(), system.getFirstEntity()) && BlueCasUtil.haveSameBeginEnd(gold.getFirstEntity(), system.getSecondEntity());
    }

    public static java.util.Comparator<Cooccurrence> comp() {
        return new java.util.Comparator<Cooccurrence>(){

            @Override
            public int compare(Cooccurrence o1, Cooccurrence o2) {
                return CooccurrencesEvaluationAnnotator.areTheSame(o1, o2) ? 0 : 1;
            }
        };
    }

    public static boolean contains(Collection<Cooccurrence> haystack, Cooccurrence needle) {
        for (Cooccurrence hay : haystack) {
            if (!CooccurrencesEvaluationAnnotator.areTheSame(hay, needle)) continue;
            return true;
        }
        return false;
    }
}

