/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.fit.component.JCasConsumer_ImplBase;
import org.apache.uima.fit.component.xwriter.XWriterFileNamer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

public class XWriter
extends JCasConsumer_ImplBase {
    @ConfigurationParameter(name="outputDir", mandatory=true, description="takes a path to directory into which output files will be written.")
    private String outputDirectoryName;
    public static final String PARAM_XML_SCHEME_NAME = "xmlSchemeName";
    @ConfigurationParameter(name="xmlSchemeName", mandatory=true, defaultValue={"XMI"}, description="specifies the UIMA XML serialization scheme that should be used. Valid values for this parameter are 'XMI' (default) and 'XCAS'.")
    private String xmlSchemeName;
    public static final String PARAM_FILE_NAMER_CLASS_NAME = "fileNamerClassName";
    @ConfigurationParameter(name="fileNamerClassName", mandatory=true, description="the class name of the XWriterFileNamer implementation to use", defaultValue={"org.apache.uima.fit.component.xwriter.IntegerFileNamer"})
    protected String fileNamerClassName;
    public static final String XMI = "XMI";
    public static final String XCAS = "XCAS";
    private File outputDirectory;
    private boolean useXMI = true;
    private XWriterFileNamer fileNamer;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.outputDirectory = new File(this.outputDirectoryName);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (this.xmlSchemeName.equals(XMI)) {
            this.useXMI = true;
        } else if (this.xmlSchemeName.equals(XCAS)) {
            this.useXMI = false;
        } else {
            throw new ResourceInitializationException(String.format("parameter '%1$s' must be either '%2$s' or '%3$s'.", PARAM_XML_SCHEME_NAME, XMI, XCAS), null);
        }
        this.fileNamer = (XWriterFileNamer)InitializableFactory.create((UimaContext)context, (String)this.fileNamerClassName, XWriterFileNamer.class);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String fileName = this.fileNamer.nameFile(jcas);
        try {
            if (this.useXMI) {
                this.writeXmi(jcas.getCas(), fileName);
            } else {
                this.writeXCas(jcas.getCas(), fileName);
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (SAXException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXCas(CAS aCas, String fileName) throws IOException, SAXException {
        File outFile = new File(this.outputDirectory, fileName + ".xcas");
        try (FileOutputStream out = null;){
            out = new FileOutputStream(outFile);
            XCASSerializer ser = new XCASSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, String id) throws IOException, SAXException {
        File outFile = new File(this.outputDirectory, id + ".xmi");
        try (FileOutputStream out = null;){
            out = new FileOutputStream(outFile);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }
}

