/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.uima.types.DocumentPage;
import de.julielab.jules.types.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@TypeCapability(inputs={"de.julielab.jules.types.Sentence"})
public class SplitInPages
extends JCasAnnotator_ImplBase {
    private int splitEvery = 10;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int sentenceCnt = 0;
        int runningPageEnd = 0;
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            if (sentenceCnt++ % this.splitEvery != 0) continue;
            new DocumentPage(jCas, runningPageEnd, sentence.getEnd()).addToIndexes();
            runningPageEnd = sentence.getEnd();
        }
    }
}

