/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.io.TextFileWriter;
import ch.epfl.bbp.uima.BlueCasUtil;
import de.julielab.jules.types.Sentence;
import java.io.File;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"de.julielab.jules.types.Sentence"})
public class SentenceDumpAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="outputFile", defaultValue={"sentences.txt"}, description="A path to the output file")
    private String outputFile;
    private TextFileWriter writer;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.writer = new TextFileWriter(new File(this.outputFile));
        }
        catch (IOException e) {
            throw new ResourceInitializationException();
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String pmId = BlueCasUtil.getHeaderDocId(jCas);
        int sentenceId = 0;
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            this.writer.addLine(pmId + ":" + sentenceId++ + "\t" + sentence.getCoveredText());
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

