/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountAnnotationsAnnotator
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(CountAnnotationsAnnotator.class);
    @ConfigurationParameter(name="annotationClass", mandatory=true, description="annotation class name to count")
    private String fromAnnotationStr;
    private Class<? extends Annotation> fromAnnotation;
    int totalCount;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.fromAnnotation = Class.forName(this.fromAnnotationStr);
            this.totalCount = 0;
        }
        catch (Throwable t) {
            throw new ResourceInitializationException(t);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int cnt = JCasUtil.select((JCas)jCas, this.fromAnnotation).size();
        LOG.info("{} {}-annotations", (Object)cnt, (Object)this.fromAnnotation.getName());
        this.totalCount += cnt;
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        LOG.info("TOTAL {} {}-annotations", (Object)this.totalCount, (Object)this.fromAnnotation.getName());
    }
}

