/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.MissingUtils;
import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.ae.output.AnnotationTypeWriter;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationTypeWriter2
extends AnnotationTypeWriter {
    private static Logger LOG = LoggerFactory.getLogger(AnnotationTypeWriter2.class);

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String pmId = BlueCasUtil.getHeaderDocId(jCas);
        try {
            for (Annotation a : jCas.getAnnotationIndex()) {
                if (!a.getClass().getName().equals(this.annotationClass)) continue;
                String featureStr = this.featureName != null ? a.getFeatureValueAsString(a.getType().getFeatureByBaseName(this.featureName)) : a.getCoveredText();
                if (this.filterFeaturesWithValue != null && featureStr.equals(this.filterFeaturesWithValue)) continue;
                this.writer.append(MissingUtils.format((String)"{}\t{}\t{}\t{}\n", (Object[])new Object[]{pmId, a.getBegin(), a.getEnd(), featureStr}));
            }
            this.writer.flush();
        }
        catch (Exception e) {
            LOG.warn("could not process " + pmId, (Throwable)e);
        }
    }
}

