/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.Histogram;
import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.typesystem.To;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationInstanceHistogramAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationInstanceHistogramAnnotator.class);
    @ConfigurationParameter(name="annotationClass", mandatory=true, description="annotation class name to count")
    private String annotationStr;
    private Class<? extends Annotation> annotation;
    @ConfigurationParameter(name="annotationField", defaultValue={"coveredText"}, description="The name of the annotation field to get the title from.", mandatory=false)
    protected String fieldRaw;
    protected Method fieldMethod;
    private Histogram<String> histogram = new Histogram();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.annotation = Class.forName(this.annotationStr);
            for (Method m : this.annotation.getMethods()) {
                if (!m.getName().equals("get" + StringUtils.capitalize((String)this.fieldRaw.trim())) || m.getParameterTypes().length != 0) continue;
                this.fieldMethod = m;
            }
            if (this.fieldMethod == null) {
                throw new RuntimeException(this.fieldRaw + " field for annot " + this.annotation.getCanonicalName() + " not found");
            }
        }
        catch (Throwable t) {
            throw new ResourceInitializationException(t);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Annotation a : JCasUtil.select((JCas)jCas, this.annotation)) {
            try {
                Object res = this.fieldMethod.invoke((Object)a, new Object[0]);
                if (res == null) continue;
                this.histogram.add((Object)res.toString().replaceAll("[\t\n]", " "));
            }
            catch (Exception e) {
                LOG.warn(BlueCasUtil.getHeaderDocId(jCas) + " could not call {} on annotation {}", (Object)this.fieldRaw, (Object)To.string((Object)a));
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        System.out.println("Histogram " + this.annotation.getSimpleName() + "::" + this.fieldRaw + "\n" + this.histogram.toString() + "------------------------\n");
    }
}

