/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.cleanup;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.DocumentBlock;
import ch.epfl.bbp.uima.types.TooFewTokensPerPage;
import de.julielab.jules.types.Token;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TooFewTokensFilterAnnotator
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(TooFewTokensFilterAnnotator.class);

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            int tokens = JCasUtil.select((JCas)jCas, Token.class).size();
            int pages = 0;
            for (DocumentBlock block : JCasUtil.select((JCas)jCas, DocumentBlock.class)) {
                pages = Math.max(pages, block.getPageId());
            }
            if (tokens < ++pages * 50) {
                new TooFewTokensPerPage(jCas).addToIndexes();
            }
        }
        catch (Exception e) {
            LOG.error("could not compute token/page ratio on pmid " + BlueCasUtil.getHeaderDocId(jCas), (Throwable)e);
        }
    }
}

