/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.cleanup;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.ae.cleanup.DisambiguatorAnnotator;
import com.google.common.collect.Lists;
import de.julielab.jules.types.Token;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class SkipSomePosAnnotator2
extends JCasAnnotator_ImplBase {
    public static final List<String> SKIP_POS = Lists.newArrayList((Object[])new String[]{"CC", "IN", "PRP", "PRP$", "PDT", "POS", "DT", "WDT", "WP", "WP$", "WRB", "TO", "EX", "LS", "RP"});

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Token t : JCasUtil.select((JCas)jCas, Token.class)) {
            String pos = t.getPos();
            if (pos == null) {
                pos = "UNKNOWN";
            }
            if (!SKIP_POS.contains(pos)) continue;
            for (Annotation a : JCasUtil.selectCovered((JCas)jCas, Annotation.class, (int)t.getBegin(), (int)t.getEnd())) {
                if (!BlueCasUtil.haveSameBeginEnd((Annotation)t, a) || !DisambiguatorAnnotator.BIO_ANNOTATIONS.contains(a.getClass())) continue;
                a.removeFromIndexes(jCas);
            }
        }
    }
}

