/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.uima.BlueCasUtil;
import de.julielab.jules.types.Sentence;
import de.julielab.jules.types.Token;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@TypeCapability(outputs={"de.julielab.jules.types.Token"}, inputs={"de.julielab.jules.types.Sentence"})
public class WhitespaceTokenizerAnnotator
extends JCasAnnotator_ImplBase {
    public static final String COMPONENT_ID = WhitespaceTokenizerAnnotator.class.getSimpleName();

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        BlueCasUtil.fixNoText(jCas);
        BlueCasUtil.fixNoSentences(jCas);
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            int start = sentence.getBegin();
            String text = sentence.getCoveredText();
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
            for (String word : text.split(" ")) {
                Token token = new Token(jCas, start, start + word.length());
                token.setComponentId(COMPONENT_ID);
                token.addToIndexes();
                start += word.length() + 1;
            }
        }
    }
}

