/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.uima.ae.EnsureTokensHaveLemmaAndPOS;
import ch.epfl.bbp.uima.utils.SnowballStemmer;
import de.julielab.jules.types.Token;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@TypeCapability(inputs={"de.julielab.jules.types.Token"})
public class SnowballAnnotator
extends JCasAnnotator_ImplBase {
    private final SnowballStemmer stemmer = new SnowballStemmer();

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        for (Token token : JCasUtil.select((JCas)jcas, Token.class)) {
            String stem = this.stemmer.stem(token.getCoveredText());
            EnsureTokensHaveLemmaAndPOS.setLemma(token, jcas, stem);
            token.setLemmaStr(stem);
        }
    }
}

