/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.typesystem.To;
import de.julielab.jules.types.Sentence;
import de.julielab.jules.types.Token;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(outputs={"de.julielab.jules.types.Token"}, inputs={"de.julielab.jules.types.Sentence"})
public class RegexTokenizerAnnotator
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(RegexTokenizerAnnotator.class);
    public static final String patterPunctDigitsCamelcase = "(?<=\\w)(?=\\W)|(?<=\\W)(?=\\w)|(?<=[A-Z])(?=[a-z])|(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)";
    public static final String patterPunctuation = "(?<=\\w)(?=\\W)|(?<=\\W)(?=\\w)";
    public static final String patterPunctuationNoDash = "(?<=[(a-zA-Z_0-9\\-)])(?=[^(a-zA-Z_0-9\\-)])|(?<=[^(a-zA-Z_0-9\\-)])(?=[(a-zA-Z_0-9\\-)])";
    public static final String PARAM_TOKENIZATION_PATTERN = "tokenizationPattern";
    @ConfigurationParameter(name="tokenizationPattern", defaultValue={"(?<=[(a-zA-Z_0-9\\-)])(?=[^(a-zA-Z_0-9\\-)])|(?<=[^(a-zA-Z_0-9\\-)])(?=[(a-zA-Z_0-9\\-)])"}, description="a String that will be compiled to a regex Pattern, and used for tokenization")
    private String tokenizationPatternString;
    private Pattern tokenizationPattern;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.tokenizationPattern = Pattern.compile(this.tokenizationPatternString);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        BlueCasUtil.fixNoSentences(jcas);
        for (Sentence sentence : JCasUtil.select((JCas)jcas, Sentence.class)) {
            String[] split;
            int start = sentence.getBegin();
            String text = sentence.getCoveredText();
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
            for (String word : split = this.tokenizationPattern.split(text)) {
                if (!word.equals(" ")) {
                    Token token = new Token(jcas, start, start + word.length());
                    token.setComponentId(RegexTokenizerAnnotator.class.getSimpleName());
                    token.addToIndexes();
                    LOG.trace("tagging Token: " + To.string((Object)token));
                }
                start += word.length();
            }
        }
    }
}

