/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.uima.types.Punctuation;
import de.julielab.jules.types.Token;
import java.util.regex.Pattern;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@TypeCapability(outputs={"ch.epfl.bbp.uima.types.Punctuation"})
public class PunctuationAnnotator
extends JCasAnnotator_ImplBase {
    public static final Pattern PUNCT = Pattern.compile("^[\\p{Punct}\u00a1\u00a2\u00a3\u00a5\u00a9\u00ae\u00b0\u00b1\u00b7\u00d7\u00e0\u0301\u0308\u0327\u2013\u2014\u201c\u201d\u204e\u25cf]+$");

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Token t : JCasUtil.select((JCas)jCas, Token.class)) {
            String text = t.getCoveredText().trim();
            if (!PUNCT.matcher(text).matches()) continue;
            new Punctuation(jCas, t.getBegin(), t.getEnd()).addToIndexes();
        }
    }
}

