/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.uima.types.AgeDictTerm;
import ch.epfl.bbp.uima.types.DictTerm;
import ch.epfl.bbp.uima.types.DiseaseDictTerm;
import ch.epfl.bbp.uima.types.DocumentTextHolder;
import ch.epfl.bbp.uima.types.IonchannelDictTerm;
import ch.epfl.bbp.uima.types.MethodDictTerm;
import ch.epfl.bbp.uima.types.MoleculeDictTerm;
import ch.epfl.bbp.uima.types.MultipleProteins;
import ch.epfl.bbp.uima.types.OrganismDictTerm;
import ch.epfl.bbp.uima.types.RegionDictTerm;
import ch.epfl.bbp.uima.types.SexDictTerm;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class LucasHelperAnnotator
extends JCasAnnotator_ImplBase {
    static final String before = "\u2282=";
    static final String after = "=\u2283";
    static final String[] inserts = new String[]{"age", "ionchannel", "disease", "organism", "sex", "region", "molecule", "method"};
    static final List<Class<? extends DictTerm>> annots = Lists.newArrayList((Object[])new Class[]{AgeDictTerm.class, IonchannelDictTerm.class, DiseaseDictTerm.class, OrganismDictTerm.class, SexDictTerm.class, RegionDictTerm.class, MoleculeDictTerm.class, MethodDictTerm.class});

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        for (int i = 0; i < annots.size(); ++i) {
            String insert = before + inserts[i].toUpperCase() + after;
            Collection selects = JCasUtil.select((JCas)jcas, annots.get(i));
            for (DictTerm d : selects) {
                d.setAnnotType(insert);
                d.setDictCanon("\u2282" + d.getDictCanon() + "\u2283");
            }
            if (!inserts[i].equals("molecule") || selects.size() <= 1) continue;
            MultipleProteins mp = new MultipleProteins(jcas);
            mp.setPresent(1);
            mp.addToIndexes();
        }
        String text = jcas.getDocumentText();
        DocumentTextHolder dth = new DocumentTextHolder(jcas, 0, text.length());
        dth.setText(text);
        dth.addToIndexes();
    }
}

