/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCopier;

public class EvaluationPreprocessorAnnotator
extends JCasAnnotator_ImplBase {
    public static final String VIEW_SYSTEM = "_InitialView";
    public static final String VIEW_GOLD = "view_gold";
    public static final String PARAM_GOLD_ANNOTATION = "gold_annotation";
    public static final String PARAM_SYSTEM_ANNOTATION = "system_annotation";
    @ConfigurationParameter(name="gold_annotation", mandatory=true, description="the annotation class name to copy to the gold view (and remove from initial view")
    private String goldAnnotationStr;
    private Class<? extends Annotation> goldAnnotation;
    public static final String DELETE_FROM = "deleteFrom";
    @ConfigurationParameter(name="deleteFrom", defaultValue={"true"}, description="whether to delete the 'from' annotations (default, what you want most of the times), or leave them")
    private boolean deleteFrom;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.goldAnnotation = Class.forName(this.goldAnnotationStr);
        }
        catch (Throwable t) {
            throw new ResourceInitializationException(t);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection goldsFromInitialView = JCasUtil.select((JCas)jCas, this.goldAnnotation);
        JCas goldView = null;
        try {
            goldView = jCas.createView(VIEW_GOLD);
        }
        catch (Throwable e) {
            throw new AnalysisEngineProcessException("no_resource_for_parameters", new Object[]{VIEW_GOLD}, e);
        }
        CasCopier casCopier = new CasCopier(jCas.getCas(), goldView.getCas());
        goldView.setDocumentText(jCas.getDocumentText());
        ArrayList<Annotation> toDelete = new ArrayList<Annotation>();
        for (Annotation g : goldsFromInitialView) {
            goldView.addFsToIndexes(casCopier.copyFs((FeatureStructure)g));
            if (!this.deleteFrom) continue;
            toDelete.add(g);
        }
        Annotation[] arr = toDelete.toArray(new Annotation[toDelete.size()]);
        for (int i = 0; i < arr.length; ++i) {
            arr[i].removeFromIndexes(jCas);
        }
    }
}

