/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import de.julielab.jules.types.Lemma;
import de.julielab.jules.types.POSTag;
import de.julielab.jules.types.Token;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

@TypeCapability(inputs={"de.julielab.jules.types.Token"})
public class EnsureTokensHaveLemmaAndPOS
extends JCasAnnotator_ImplBase {
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        for (Token token : JCasUtil.select((JCas)jcas, Token.class)) {
            if (token.getPosTag() == null) {
                EnsureTokensHaveLemmaAndPOS.setPosTags(token, jcas, "null");
            }
            if (token.getLemma() != null) continue;
            EnsureTokensHaveLemmaAndPOS.setLemma(token, jcas, token.getCoveredText());
        }
    }

    public static void setPosTags(Token token, JCas jcas, String ... posTags) {
        FSArray slots = new FSArray(jcas, posTags.length);
        for (int i = 0; i < posTags.length; ++i) {
            POSTag posTag = new POSTag(jcas);
            posTag.setValue(posTags[i]);
            posTag.addToIndexes();
            slots.set(i, (FeatureStructure)posTag);
        }
        token.setPosTag(slots);
    }

    public static void setLemma(Token token, JCas jcas, String lemmaStr) {
        Lemma lemma = new Lemma(jcas);
        lemma.setValue(lemmaStr);
        lemma.addToIndexes();
        token.setLemma(lemma);
    }
}

