/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import de.julielab.jules.types.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;

@TypeCapability(outputs={"de.julielab.jules.types.Sentence"})
public class DotSentenceSplitterAnnotator
extends JCasAnnotator_ImplBase {
    private static final String COMPONENT_ID = DotSentenceSplitterAnnotator.class.getSimpleName();

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String text = jcas.getDocumentText();
        if (text.indexOf(46) == -1) {
            Sentence sentence = new Sentence(jcas, 0, text.length());
            sentence.setComponentId(COMPONENT_ID);
            sentence.addToIndexes();
        } else {
            int i = 0;
            for (String dotSpaceSplit : text.split("\\. ")) {
                for (String sentenceText : dotSpaceSplit.split("\\.")) {
                    Sentence sentence = new Sentence(jcas, i, Math.min(text.length(), i + sentenceText.length() + 1));
                    sentence.setComponentId(COMPONENT_ID);
                    sentence.addToIndexes();
                    i += sentenceText.length() + 1;
                }
                ++i;
            }
        }
    }
}

