/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class DeduplicatorAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="annotationClasses", mandatory=true, description="an array with the full name of each annotation classes")
    private String[] annotationClasses;
    private List<String> annotationClassesList;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.annotationClassesList = Arrays.asList(this.annotationClasses);
        for (String annotationClass : this.annotationClasses) {
            try {
                Class<?> classz = Class.forName(annotationClass);
            }
            catch (Exception e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashMap<String, ArrayListMultimap> map = new HashMap<String, ArrayListMultimap>();
        for (Annotation a : jCas.getAnnotationIndex()) {
            String name = a.getClass().getName();
            if (!this.annotationClassesList.contains(name)) continue;
            if (!map.containsKey(name)) {
                map.put(name, ArrayListMultimap.create());
            }
            String begEnd = a.getBegin() + ":" + a.getEnd();
            ((Multimap)map.get(name)).put((Object)begEnd, (Object)a);
        }
        for (String aClass : map.keySet()) {
            Multimap asMap = (Multimap)map.get(aClass);
            for (String begEnd : asMap.keySet()) {
                ArrayList as = Lists.newArrayList((Iterable)asMap.get((Object)begEnd));
                while (as.size() > 1) {
                    ((Annotation)as.get(0)).removeFromIndexes(jCas);
                    as.remove(0);
                }
            }
        }
    }
}

