/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class CopyAnnotationsAnnotator
extends JCasAnnotator_ImplBase {
    public static final String FROM_ANNOTATION = "from";
    @ConfigurationParameter(name="from", mandatory=true, description="annotation class name to copy")
    private String fromAnnotationStr;
    private Class<? extends Annotation> fromAnnotation;
    public static final String TO_ANNOTATION = "to";
    @ConfigurationParameter(name="to", mandatory=true, description="annotation class name to copy")
    private String toAnnotationStr;
    private Class<? extends Annotation> toAnnotation;
    public static final String FROM_VIEW = "fromView";
    @ConfigurationParameter(name="fromView", mandatory=false, description="view name to copy from", defaultValue={"_InitialView"})
    private String fromViewStr;
    public static final String TO_VIEW = "toView";
    @ConfigurationParameter(name="toView", mandatory=false, description="view name to copy from", defaultValue={"_InitialView"})
    private String toViewStr;
    public static final String DELETE_FROM = "deleteFrom";
    @ConfigurationParameter(name="deleteFrom", defaultValue={"true"}, description="whether to delete the 'from' annotations (default), or leave them")
    private boolean deleteFrom;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.fromAnnotation = Class.forName(this.fromAnnotationStr);
            this.toAnnotation = Class.forName(this.toAnnotationStr);
        }
        catch (Throwable t) {
            throw new ResourceInitializationException(t);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Annotation[] froms;
        JCas fromJCas = jCas;
        JCas toJCas = jCas;
        try {
            if (!this.fromViewStr.equals("_InitialView")) {
                fromJCas = jCas.getView(this.fromViewStr);
            }
            if (!this.toViewStr.equals("_InitialView")) {
                toJCas = jCas.getView(this.toViewStr);
            }
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        Collection fromsCol = JCasUtil.select((JCas)fromJCas, this.fromAnnotation);
        for (Annotation from : froms = fromsCol.toArray(new Annotation[fromsCol.size()])) {
            try {
                Annotation to = this.toAnnotation.getDeclaredConstructor(JCas.class, Integer.TYPE, Integer.TYPE).newInstance(toJCas, from.getBegin(), from.getEnd());
                toJCas.addFsToIndexes((FeatureStructure)to);
            }
            catch (Exception e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
        if (this.deleteFrom) {
            for (int i = 0; i < froms.length; ++i) {
                froms[i].removeFromIndexes(fromJCas);
            }
        }
    }
}

