/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.acra.config.ACRAConfigurationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u001a\u0010\u0005\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\"\u0006\u0012\u0002\b\u00030\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/acra/config/ClassValidator;", "", "()V", "check", "", "classes", "", "Ljava/lang/Class;", "([Ljava/lang/Class;)V", "acra-javacore"})
public final class ClassValidator {
    @NotNull
    public static final ClassValidator INSTANCE = new ClassValidator();

    private ClassValidator() {
    }

    @JvmStatic
    public static final void check(Class<?> ... classes) throws ACRAConfigurationException {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) {
                throw new ACRAConfigurationException("Expected class, but found interface " + clazz.getName() + '.');
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new ACRAConfigurationException("Class " + clazz.getName() + " cannot be abstract.");
            }
            if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                throw new ACRAConfigurationException("Class " + clazz.getName() + " has to be static.");
            }
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ACRAConfigurationException("Class " + clazz.getName() + " is missing a no-args Constructor.", e);
            }
        }
    }
}

