/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collections;

import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;

public class WeakStack<T>
extends AbstractCollection<T> {
    private final List<WeakReference<T>> contents = new ArrayList<WeakReference<T>>();

    private void cleanup() {
        for (WeakReference<T> weakReference : this.contents) {
            if (weakReference.get() != null) continue;
            this.contents.remove(weakReference);
        }
    }

    @Override
    public int size() {
        this.cleanup();
        return this.contents.size();
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            for (WeakReference<T> weakReference : this.contents) {
                if (!o.equals(weakReference.get())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new WeakIterator(this.contents.iterator());
    }

    @Override
    public boolean add(T t) {
        return this.contents.add(new WeakReference<T>(t));
    }

    @Override
    public boolean remove(Object o) {
        if (o != null) {
            for (int i = 0; i < this.contents.size(); ++i) {
                if (!o.equals(this.contents.get(i).get())) continue;
                this.contents.remove(i);
                return true;
            }
        }
        return false;
    }

    public T peek() {
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Object result = this.contents.get(i).get();
            if (result == null) continue;
            return result;
        }
        throw new EmptyStackException();
    }

    public T pop() {
        T result = this.peek();
        this.remove(result);
        return result;
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    private static class WeakIterator<T>
    implements Iterator<T> {
        private final Iterator<WeakReference<T>> iterator;
        private T next;

        private WeakIterator(Iterator<WeakReference<T>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                Object t = this.iterator.next().get();
                if (t == null) continue;
                this.next = t;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            T result = this.next;
            this.next = null;
            while (result == null) {
                result = this.iterator.next().get();
            }
            return result;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

