/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collections;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public final class BoundedLinkedList<E>
extends LinkedList<E> {
    private final int maxSize;

    public BoundedLinkedList(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(E object) {
        if (this.size() == this.maxSize) {
            this.removeFirst();
        }
        return super.add(object);
    }

    @Override
    public void add(int location, E object) {
        if (this.size() == this.maxSize) {
            this.removeFirst();
        }
        super.add(location, object);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends E> collection) {
        int overhead;
        int size = collection.size();
        if (size > this.maxSize) {
            collection = new ArrayList<E>(collection).subList(size - this.maxSize, size);
        }
        if ((overhead = this.size() + collection.size() - this.maxSize) > 0) {
            this.removeRange(0, overhead);
        }
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int location, Collection<? extends E> collection) {
        if (location == this.size()) {
            return super.addAll(location, collection);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFirst(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLast(E object) {
        this.add(object);
    }

    @Override
    @NonNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Object object : this) {
            result.append(object.toString());
        }
        return result.toString();
    }

    @Override
    public boolean offer(E o) {
        return this.add(o);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        return this.add(e);
    }

    @Override
    public void push(E e) {
        this.add(e);
    }
}

