/*
 *  Copyright 2016
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.acra.collections;

import java.util.Iterator;

/**
 * Wrapper around an Iterator which prevents modifications
 *
 * @author F43nd1r
 * @since 4.9.0
 */
class UnmodifiableIteratorWrapper<E> implements Iterator<E> {
    private final Iterator<E> mIterator;

    UnmodifiableIteratorWrapper(Iterator<E> mIterator) {
        this.mIterator = mIterator;
    }

    @Override
    public boolean hasNext() {
        return mIterator.hasNext();
    }

    @Override
    public E next() {
        return mIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}
