/*
 * Decompiled with CFR 0.152.
 */
package org.acra.dialog;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.file.BulkReportDeleter;
import org.acra.file.CrashReportPersister;
import org.acra.scheduler.SchedulerStarter;
import org.json.JSONException;

public class CrashReportDialogHelper {
    private final File reportFile;
    private final CoreConfiguration config;
    private final Context context;
    private CrashReportData reportData;

    public CrashReportDialogHelper(@NonNull Context context, @NonNull Intent intent) throws IllegalArgumentException {
        this.context = context;
        Serializable sConfig = intent.getSerializableExtra("REPORT_CONFIG");
        Serializable sReportFile = intent.getSerializableExtra("REPORT_FILE");
        if (!(sConfig instanceof CoreConfiguration) || !(sReportFile instanceof File)) {
            ACRA.log.w(ACRA.LOG_TAG, "Illegal or incomplete call of " + this.getClass().getSimpleName());
            throw new IllegalArgumentException();
        }
        this.config = (CoreConfiguration)sConfig;
        this.reportFile = (File)sReportFile;
    }

    @WorkerThread
    @NonNull
    public CrashReportData getReportData() throws IOException {
        if (this.reportData == null) {
            try {
                this.reportData = new CrashReportPersister().load(this.reportFile);
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
        return this.reportData;
    }

    public void cancelReports() {
        new Thread(() -> new BulkReportDeleter(this.context).deleteReports(false, 0)).start();
    }

    public void sendCrash(@Nullable String comment, @Nullable String userEmail) {
        new Thread(() -> {
            try {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "Add user comment to " + this.reportFile);
                }
                CrashReportData crashData = this.getReportData();
                crashData.put(ReportField.USER_COMMENT, comment == null ? "" : comment);
                crashData.put(ReportField.USER_EMAIL, userEmail == null ? "" : userEmail);
                new CrashReportPersister().store(crashData, this.reportFile);
            }
            catch (IOException | JSONException e) {
                ACRA.log.w(ACRA.LOG_TAG, "User comment not added: ", e);
            }
            new SchedulerStarter(this.context, this.config).scheduleReports(this.reportFile, false);
        }).start();
    }

    public CoreConfiguration getConfig() {
        return this.config;
    }
}

