/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import org.acra.annotation.AcraDialog;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.ClassValidator;
import org.acra.config.DialogConfiguration;
import org.acra.config.DialogConfigurationBuilder;
import org.acra.dialog.CrashReportDialog;

final class DialogConfigurationBuilderImpl
implements DialogConfigurationBuilder {
    @NonNull
    private final Context context;
    private boolean enabled;
    @NonNull
    private Class<? extends Activity> reportDialogClass;
    @NonNull
    private String positiveButtonText;
    @NonNull
    private String negativeButtonText;
    @Nullable
    private String commentPrompt;
    @Nullable
    private String emailPrompt;
    @DrawableRes
    private int resIcon;
    @Nullable
    private String text;
    @Nullable
    private String title;
    @StyleRes
    private int resTheme;

    DialogConfigurationBuilderImpl(@NonNull Context arg0) {
        AcraDialog annotation = arg0.getClass().getAnnotation(AcraDialog.class);
        this.context = arg0;
        boolean bl = this.enabled = annotation != null;
        if (this.enabled) {
            this.reportDialogClass = annotation.reportDialogClass();
            if (annotation.resPositiveButtonText() != 0) {
                this.positiveButtonText = this.context.getString(annotation.resPositiveButtonText());
            }
            if (annotation.resNegativeButtonText() != 0) {
                this.negativeButtonText = this.context.getString(annotation.resNegativeButtonText());
            }
            if (annotation.resCommentPrompt() != 0) {
                this.commentPrompt = this.context.getString(annotation.resCommentPrompt());
            }
            if (annotation.resEmailPrompt() != 0) {
                this.emailPrompt = this.context.getString(annotation.resEmailPrompt());
            }
            this.resIcon = annotation.resIcon();
            if (annotation.resText() != 0) {
                this.text = this.context.getString(annotation.resText());
            }
            if (annotation.resTitle() != 0) {
                this.title = this.context.getString(annotation.resTitle());
            }
            this.resTheme = annotation.resTheme();
        } else {
            this.reportDialogClass = CrashReportDialog.class;
            this.positiveButtonText = this.context.getString(17039370);
            this.negativeButtonText = this.context.getString(0x1040000);
            this.resIcon = 17301543;
            this.resTheme = 0;
        }
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    boolean enabled() {
        return this.enabled;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setReportDialogClass(@NonNull Class<? extends Activity> reportDialogClass) {
        this.reportDialogClass = reportDialogClass;
        return this;
    }

    @NonNull
    Class<? extends Activity> reportDialogClass() {
        return this.reportDialogClass;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setPositiveButtonText(@NonNull String positiveButtonText) {
        this.positiveButtonText = positiveButtonText;
        return this;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setResPositiveButtonText(@StringRes int resPositiveButtonText) {
        this.positiveButtonText = this.context.getString(resPositiveButtonText);
        return this;
    }

    @NonNull
    String positiveButtonText() {
        return this.positiveButtonText;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setNegativeButtonText(@NonNull String negativeButtonText) {
        this.negativeButtonText = negativeButtonText;
        return this;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setResNegativeButtonText(@StringRes int resNegativeButtonText) {
        this.negativeButtonText = this.context.getString(resNegativeButtonText);
        return this;
    }

    @NonNull
    String negativeButtonText() {
        return this.negativeButtonText;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setCommentPrompt(@Nullable String commentPrompt) {
        this.commentPrompt = commentPrompt;
        return this;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setResCommentPrompt(@StringRes int resCommentPrompt) {
        this.commentPrompt = this.context.getString(resCommentPrompt);
        return this;
    }

    @Nullable
    String commentPrompt() {
        return this.commentPrompt;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setEmailPrompt(@Nullable String emailPrompt) {
        this.emailPrompt = emailPrompt;
        return this;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setResEmailPrompt(@StringRes int resEmailPrompt) {
        this.emailPrompt = this.context.getString(resEmailPrompt);
        return this;
    }

    @Nullable
    String emailPrompt() {
        return this.emailPrompt;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setResIcon(@DrawableRes int resIcon) {
        this.resIcon = resIcon;
        return this;
    }

    @DrawableRes
    int resIcon() {
        return this.resIcon;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setText(@Nullable String text) {
        this.text = text;
        return this;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setResText(@StringRes int resText) {
        this.text = this.context.getString(resText);
        return this;
    }

    @Nullable
    String text() {
        return this.text;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setResTitle(@StringRes int resTitle) {
        this.title = this.context.getString(resTitle);
        return this;
    }

    @Nullable
    String title() {
        return this.title;
    }

    @Override
    @NonNull
    public DialogConfigurationBuilderImpl setResTheme(@StyleRes int resTheme) {
        this.resTheme = resTheme;
        return this;
    }

    @StyleRes
    int resTheme() {
        return this.resTheme;
    }

    @NonNull
    public DialogConfiguration build() throws ACRAConfigurationException {
        if (this.enabled) {
            ClassValidator.check((Class[])new Class[]{this.reportDialogClass});
            if (this.reportDialogClass == CrashReportDialog.class && this.text == null) {
                throw new ACRAConfigurationException("One of reportDialogClass, text must not be default");
            }
        }
        return new DialogConfiguration(this);
    }
}

