/*
 * Decompiled with CFR 0.152.
 */
package org.acra.interaction;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.Serializable;
import org.acra.ACRA;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.DialogConfiguration;
import org.acra.interaction.ReportInteraction;
import org.acra.plugins.HasConfigPlugin;
import org.acra.prefs.SharedPreferencesFactory;

public class DialogInteraction
extends HasConfigPlugin
implements ReportInteraction {
    public static final String EXTRA_REPORT_FILE = "REPORT_FILE";
    public static final String EXTRA_REPORT_CONFIG = "REPORT_CONFIG";

    public DialogInteraction() {
        super(DialogConfiguration.class);
    }

    public boolean performInteraction(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull File reportFile) {
        SharedPreferences prefs = new SharedPreferencesFactory(context, config).create();
        if (prefs.getBoolean("acra.alwaysaccept", false)) {
            return true;
        }
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Creating CrashReportDialog for " + reportFile);
        }
        Intent dialogIntent = this.createCrashReportDialogIntent(context, config, reportFile);
        dialogIntent.setFlags(0x10000000);
        context.startActivity(dialogIntent);
        return false;
    }

    @NonNull
    private Intent createCrashReportDialogIntent(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull File reportFile) {
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Creating DialogIntent for " + reportFile);
        }
        Intent dialogIntent = new Intent(context, ((DialogConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, DialogConfiguration.class)).reportDialogClass());
        dialogIntent.putExtra(EXTRA_REPORT_FILE, (Serializable)reportFile);
        dialogIntent.putExtra(EXTRA_REPORT_CONFIG, (Serializable)config);
        return dialogIntent;
    }
}

