/*
 * Decompiled with CFR 0.152.
 */
package org.acra.interaction;

import android.content.Context;
import android.content.Intent;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.DialogConfiguration;
import org.acra.interaction.ReportInteraction;
import org.acra.log.ACRALog;
import org.acra.plugins.HasConfigPlugin;
import org.acra.prefs.SharedPreferencesFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0012\u00a8\u0006\u0010"}, d2={"Lorg/acra/interaction/DialogInteraction;", "Lorg/acra/plugins/HasConfigPlugin;", "Lorg/acra/interaction/ReportInteraction;", "<init>", "()V", "performInteraction", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportFile", "Ljava/io/File;", "createCrashReportDialogIntent", "Landroid/content/Intent;", "Companion", "acra-dialog_release"})
@AutoService(value={ReportInteraction.class})
@SourceDebugExtension(value={"SMAP\nDialogInteraction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogInteraction.kt\norg/acra/interaction/DialogInteraction\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n+ 3 ConfigUtils.kt\norg/acra/config/ConfigUtils\n*L\n1#1,79:1\n7#2,2:80\n7#2,2:82\n29#3:84\n*S KotlinDebug\n*F\n+ 1 DialogInteraction.kt\norg/acra/interaction/DialogInteraction\n*L\n43#1:80,2\n56#1:82,2\n57#1:84\n*E\n"})
public class DialogInteraction
extends HasConfigPlugin
implements ReportInteraction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXTRA_REPORT_FILE = "REPORT_FILE";
    @NotNull
    public static final String EXTRA_REPORT_CONFIG = "REPORT_CONFIG";

    public DialogInteraction() {
        super(DialogConfiguration.class);
    }

    public boolean performInteraction(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull File reportFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportFile, (String)"reportFile");
        if (new SharedPreferencesFactory(context, config).create().getBoolean("acra.alwaysaccept", false)) {
            return true;
        }
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Creating CrashReportDialog for " + reportFile;
            aCRALog.d(string, string2);
        }
        Intent dialogIntent = this.createCrashReportDialogIntent(context, config, reportFile);
        dialogIntent.setFlags(0x10000000);
        context.startActivity(dialogIntent);
        return false;
    }

    private Intent createCrashReportDialogIntent(Context context, CoreConfiguration config, File reportFile) {
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Creating DialogIntent for " + reportFile;
            aCRALog.d(string, string2);
        }
        CoreConfiguration $this$getPluginConfiguration$iv = config;
        boolean $i$f$getPluginConfiguration = false;
        Intent dialogIntent = new Intent(context, ((DialogConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)$this$getPluginConfiguration$iv, DialogConfiguration.class)).getReportDialogClass());
        dialogIntent.putExtra(EXTRA_REPORT_FILE, (Serializable)reportFile);
        dialogIntent.putExtra(EXTRA_REPORT_CONFIG, (Serializable)config);
        return dialogIntent;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/acra/interaction/DialogInteraction$Companion;", "", "<init>", "()V", "EXTRA_REPORT_FILE", "", "EXTRA_REPORT_CONFIG", "acra-dialog_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

