/*
 * Decompiled with CFR 0.152.
 */
package org.acra.dialog;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.WorkerThread;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.file.BulkReportDeleter;
import org.acra.file.CrashReportPersister;
import org.acra.log.ACRALog;
import org.acra.scheduler.SchedulerStarter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/acra/dialog/CrashReportDialogHelper;", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "(Landroid/content/Context;Landroid/content/Intent;)V", "config", "Lorg/acra/config/CoreConfiguration;", "getConfig", "()Lorg/acra/config/CoreConfiguration;", "reportData", "Lorg/acra/data/CrashReportData;", "getReportData", "()Lorg/acra/data/CrashReportData;", "reportData$delegate", "Lkotlin/Lazy;", "reportFile", "Ljava/io/File;", "cancelReports", "", "sendCrash", "comment", "", "userEmail", "acra-dialog_release"})
@SourceDebugExtension(value={"SMAP\nCrashReportDialogHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashReportDialogHelper.kt\norg/acra/dialog/CrashReportDialogHelper\n+ 2 intent.kt\norg/acra/util/IntentKt\n+ 3 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,121:1\n23#2,6:122\n23#2,6:128\n23#3,2:134\n7#3,2:136\n19#3,2:138\n19#3,2:140\n*S KotlinDebug\n*F\n+ 1 CrashReportDialogHelper.kt\norg/acra/dialog/CrashReportDialogHelper\n*L\n63#1:122,6\n64#1:128,6\n69#1:134,2\n106#1:136,2\n112#1:138,2\n114#1:140,2\n*E\n"})
public final class CrashReportDialogHelper {
    @NotNull
    private final Context context;
    @NotNull
    private final File reportFile;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final Lazy reportData$delegate;

    /*
     * WARNING - void declaration
     */
    public CrashReportDialogHelper(@NotNull Context context, @NotNull Intent intent) {
        Serializable serializable;
        void $this$kGetSerializableExtra$iv;
        Serializable serializable2;
        void $this$kGetSerializableExtra$iv2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.context = context;
        Intent intent2 = intent;
        String name$iv = "REPORT_CONFIG";
        boolean $i$f$kGetSerializableExtra = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable2 = $this$kGetSerializableExtra$iv2.getSerializableExtra(name$iv, CoreConfiguration.class);
        } else {
            Serializable serializable3 = $this$kGetSerializableExtra$iv2.getSerializableExtra(name$iv);
            if (!(serializable3 instanceof CoreConfiguration)) {
                serializable3 = null;
            }
            serializable2 = (Serializable)((CoreConfiguration)serializable3);
        }
        CoreConfiguration sConfig = (CoreConfiguration)serializable2;
        name$iv = intent;
        String name$iv2 = "REPORT_FILE";
        boolean $i$f$kGetSerializableExtra2 = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable = $this$kGetSerializableExtra$iv.getSerializableExtra(name$iv2, File.class);
        } else {
            Serializable serializable4 = $this$kGetSerializableExtra$iv.getSerializableExtra(name$iv2);
            if (!(serializable4 instanceof File)) {
                serializable4 = null;
            }
            serializable = (File)serializable4;
        }
        File sReportFile = (File)serializable;
        if (sConfig == null || sReportFile == null) {
            boolean $i$f$error = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Illegal or incomplete call of " + this.getClass().getSimpleName();
            aCRALog.e(string, string2);
            throw new IllegalArgumentException();
        }
        this.config = sConfig;
        this.reportFile = sReportFile;
        this.reportData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CrashReportData>(this){
            final /* synthetic */ CrashReportDialogHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CrashReportData invoke() {
                CrashReportData crashReportData;
                try {
                    crashReportData = new CrashReportPersister().load(CrashReportDialogHelper.access$getReportFile$p(this.this$0));
                }
                catch (JSONException e) {
                    throw new IOException(e);
                }
                return crashReportData;
            }
        }));
    }

    @NotNull
    public final CoreConfiguration getConfig() {
        return this.config;
    }

    @WorkerThread
    @NotNull
    public final CrashReportData getReportData() throws IOException {
        Lazy lazy = this.reportData$delegate;
        return (CrashReportData)lazy.getValue();
    }

    public final void cancelReports() {
        new Thread(() -> CrashReportDialogHelper.cancelReports$lambda$1(this)).start();
    }

    public final void sendCrash(@Nullable String comment, @Nullable String userEmail) {
        new Thread(() -> CrashReportDialogHelper.sendCrash$lambda$5(this, comment, userEmail)).start();
    }

    private static final void cancelReports$lambda$1(CrashReportDialogHelper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        new BulkReportDeleter(this$0.context).deleteReports(false, 0);
    }

    private static final void sendCrash$lambda$5(CrashReportDialogHelper this$0, String $comment, String $userEmail) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = "Add user comment to " + this$0.reportFile;
                aCRALog.d(string, string2);
            }
            CrashReportData crashData = this$0.getReportData();
            String string = $comment;
            if (string == null) {
                string = "";
            }
            crashData.put(ReportField.USER_COMMENT, string);
            String string3 = $userEmail;
            if (string3 == null) {
                string3 = "";
            }
            crashData.put(ReportField.USER_EMAIL, string3);
            new CrashReportPersister().store(crashData, this$0.reportFile);
        }
        catch (IOException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string4 = "User comment not added: ";
            aCRALog.w(string, string4, (Throwable)e);
        }
        catch (JSONException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string5 = "User comment not added: ";
            aCRALog.w(string, string5, (Throwable)e);
        }
        new SchedulerStarter(this$0.context, this$0.config).scheduleReports(this$0.reportFile, false);
    }

    public static final /* synthetic */ File access$getReportFile$p(CrashReportDialogHelper $this) {
        return $this.reportFile;
    }
}

