/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J/\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\tJ\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\rH\u0007\u00a8\u0006\u0016"}, d2={"Lorg/acra/util/IOUtils;", "", "()V", "deleteFile", "", "file", "Ljava/io/File;", "deserialize", "T", "Ljava/io/Serializable;", "clazz", "Ljava/lang/Class;", "s", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/io/Serializable;", "safeClose", "closeable", "Ljava/io/Closeable;", "serialize", "serializable", "writeStringToFile", "content", "acra-core_release"})
public final class IOUtils {
    public static final IOUtils INSTANCE;

    @JvmStatic
    public static final void safeClose(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final void deleteFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean deleted = file.delete();
        if (!deleted) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Could not delete file: " + file;
            aCRALog.w(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void writeStringToFile(@NotNull File file, @NotNull String content) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.write(content);
            writer.flush();
        }
        finally {
            IOUtils.safeClose(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String serialize(@NotNull Serializable serializable) {
        Intrinsics.checkNotNullParameter((Object)serializable, (String)"serializable");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Closeable closeable = new ObjectOutputStream(out);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ObjectOutputStream outputStream = (ObjectOutputStream)closeable;
                boolean bl3 = false;
                outputStream.writeObject(serializable);
                String string = Base64.encodeToString((byte[])out.toByteArray(), (int)0);
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T extends Serializable> T deserialize(@NotNull Class<T> clazz, @Nullable String s) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (s != null) {
            try {
                Closeable closeable = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((String)s, (int)0)));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ObjectInputStream inputStream = (ObjectInputStream)closeable;
                    boolean bl3 = false;
                    Object o = inputStream.readObject();
                    if (clazz.isInstance(o)) {
                        Serializable serializable = (Serializable)clazz.cast(o);
                        return (T)serializable;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private IOUtils() {
    }

    static {
        IOUtils iOUtils;
        INSTANCE = iOUtils = new IOUtils();
    }
}

