/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.log.ACRALog;
import org.acra.plugins.PluginLoader;
import org.acra.sender.NullSender;
import org.acra.sender.ReportDistributor;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderFactory;
import org.acra.util.ToastSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/acra/sender/SendingConductor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "locator", "Lorg/acra/file/ReportLocator;", "getSenderInstances", "", "Lorg/acra/sender/ReportSender;", "foreground", "", "sendReports", "", "extras", "Landroid/os/Bundle;", "acra-core_release"})
public final class SendingConductor {
    private final ReportLocator locator;
    private final Context context;
    private final CoreConfiguration config;

    public final void sendReports(boolean foreground, @NotNull Bundle extras) {
        String string;
        ACRALog aCRALog;
        String string2;
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "About to start sending reports from SenderService";
            aCRALog.d(string2, string);
        }
        try {
            String toast;
            List senderInstances = CollectionsKt.toMutableList((Collection)this.getSenderInstances(foreground));
            if (senderInstances.isEmpty()) {
                boolean $i$f$debug2 = false;
                if (ACRA.DEV_LOGGING) {
                    string2 = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    string = "No ReportSenders configured - adding NullSender";
                    aCRALog.d(string2, string);
                }
                senderInstances.add(new NullSender());
            }
            File[] reports = this.locator.getApprovedReports();
            ReportDistributor reportDistributor = new ReportDistributor(this.context, this.config, senderInstances, extras);
            int reportsSentCount = 0;
            CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
            boolean anyNonSilent = false;
            for (File report : reports) {
                boolean isNonSilent;
                String string3 = report.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"report.name");
                boolean bl = isNonSilent = !fileNameParser.isSilent(string3);
                if (extras.getBoolean("onlySendSilentReports") && isNonSilent) continue;
                anyNonSilent |= isNonSilent;
                if (reportsSentCount >= 5) break;
                if (!reportDistributor.distribute(report)) continue;
                int n = reportsSentCount;
                reportsSentCount = n + 1;
            }
            String string4 = toast = reportsSentCount > 0 ? this.config.getReportSendSuccessToast() : this.config.getReportSendFailureToast();
            if (anyNonSilent) {
                CharSequence charSequence = toast;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    boolean $i$f$debug3 = false;
                    if (ACRA.DEV_LOGGING) {
                        string2 = ACRA.LOG_TAG;
                        aCRALog = ACRA.log;
                        boolean bl2 = false;
                        string = "About to show " + (reportsSentCount > 0 ? "success" : "failure") + " toast";
                        aCRALog.d(string2, string);
                    }
                    new Handler(Looper.getMainLooper()).post(new Runnable(this, toast){
                        final /* synthetic */ SendingConductor this$0;
                        final /* synthetic */ String $toast;

                        public final void run() {
                            ToastSender.sendToast(SendingConductor.access$getContext$p(this.this$0), this.$toast, 1);
                        }
                        {
                            this.this$0 = sendingConductor;
                            this.$toast = string;
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            boolean $i$f$error = false;
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "";
            aCRALog.e(string2, string, e);
        }
        $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "Finished sending reports from SenderService";
            aCRALog.d(string2, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ReportSender> getSenderInstances(boolean foreground) {
        void $this$filterTo$iv$iv;
        ReportSender it;
        Iterable $this$mapTo$iv$iv;
        void $this$loadEnabled$iv;
        String string;
        Object object;
        Object object2;
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            object2 = ACRA.LOG_TAG;
            object = ACRA.log;
            boolean bl = false;
            string = "Using PluginLoader to find ReportSender factories";
            object.d((String)object2, string);
        }
        PluginLoader bl = this.config.getPluginLoader();
        CoreConfiguration config$iv = this.config;
        boolean $i$f$loadEnabled22 = false;
        List<ReportSenderFactory> factories = $this$loadEnabled$iv.loadEnabled(config$iv, ReportSenderFactory.class);
        boolean $i$f$debug2 = false;
        if (ACRA.DEV_LOGGING) {
            object2 = ACRA.LOG_TAG;
            object = ACRA.log;
            boolean bl2 = false;
            string = "reportSenderFactories : " + factories;
            object.d((String)object2, string);
        }
        Iterable $this$map$iv = factories;
        boolean $i$f$map = false;
        Iterable $i$f$loadEnabled22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ReportSenderFactory reportSenderFactory = (ReportSenderFactory)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            ReportSender reportSender = it.create(this.context, this.config);
            boolean bl4 = false;
            boolean bl5 = false;
            ReportSender it2 = reportSender;
            boolean bl6 = false;
            boolean $i$f$debug3 = false;
            if (ACRA.DEV_LOGGING) {
                String string2 = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl7 = false;
                String string3 = "Adding reportSender : " + it2;
                aCRALog.d(string2, string3);
            }
            object2 = reportSender;
            object.add(object2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ReportSender)element$iv$iv;
            boolean bl8 = false;
            if (!(foreground == it.requiresForeground())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public SendingConductor(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        this.locator = new ReportLocator(this.context);
    }

    public static final /* synthetic */ Context access$getContext$p(SendingConductor $this) {
        return $this.context;
    }
}

