/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.text.TextUtils;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.collector.StacktraceCollector$WhenMappings;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/acra/collector/StacktraceCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "getStackTrace", "", "msg", "th", "", "getStackTraceHash", "shouldCollect", "", "acra-core_release"})
public final class StacktraceCollector
extends BaseReportFieldCollector {
    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.FIRST;
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        switch (StacktraceCollector$WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                target.put(ReportField.STACK_TRACE, this.getStackTrace(reportBuilder.getMessage(), reportBuilder.getException()));
                break;
            }
            case 2: {
                target.put(ReportField.STACK_TRACE_HASH, this.getStackTraceHash(reportBuilder.getException()));
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)collect, (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return collect == ReportField.STACK_TRACE || super.shouldCollect(context, config, collect, reportBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getStackTrace(String msg, Throwable th) {
        Writer result = new StringWriter();
        Closeable closeable = new PrintWriter(result);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PrintWriter printWriter = (PrintWriter)closeable;
            boolean bl3 = false;
            if (msg != null && !TextUtils.isEmpty((CharSequence)msg)) {
                printWriter.println(msg);
            }
            Throwable throwable2 = th;
            if (throwable2 != null) {
                throwable2.printStackTrace(printWriter);
            }
            String string = result.toString();
            return string;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String getStackTraceHash(Throwable th) {
        StringBuilder res = new StringBuilder();
        for (Throwable cause = th; cause != null; cause = cause.getCause()) {
            StackTraceElement[] stackTraceElements;
            StackTraceElement[] stackTraceElementArray = stackTraceElements = cause.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement e;
                StackTraceElement stackTraceElement = e = stackTraceElementArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"e");
                res.append(stackTraceElement.getClassName());
                res.append(e.getMethodName());
            }
        }
        String string = Integer.toHexString(res.toString().hashCode());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Integer.toHexString(res.toString().hashCode())");
        return string;
    }

    public StacktraceCollector() {
        super(ReportField.STACK_TRACE, ReportField.STACK_TRACE_HASH);
    }
}

