/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.log.ACRALog;
import org.acra.plugins.PluginLoader;
import org.acra.sender.NullSender;
import org.acra.sender.ReportDistributor;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderFactory;
import org.acra.util.ToastSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/acra/sender/SendingConductor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "locator", "Lorg/acra/file/ReportLocator;", "getSenderInstances", "", "Lorg/acra/sender/ReportSender;", "foreground", "", "sendReports", "", "extras", "Landroid/os/Bundle;", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nSendingConductor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendingConductor.kt\norg/acra/sender/SendingConductor\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n+ 3 PluginLoader.kt\norg/acra/plugins/PluginLoaderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n7#2,2:73\n7#2,2:75\n7#2,2:77\n27#2,2:79\n7#2,2:81\n7#2,2:83\n7#2,2:86\n7#2,2:92\n30#3:85\n1549#4:88\n1620#4,2:89\n1622#4:94\n766#4:95\n857#4,2:96\n1#5:91\n*S KotlinDebug\n*F\n+ 1 SendingConductor.kt\norg/acra/sender/SendingConductor\n*L\n25#1:73,2\n29#1:75,2\n56#1:77,2\n60#1:79,2\n62#1:81,2\n66#1:83,2\n68#1:86,2\n69#1:92,2\n67#1:85\n69#1:88\n69#1:89,2\n69#1:94\n69#1:95\n69#1:96,2\n*E\n"})
public final class SendingConductor {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final ReportLocator locator;

    public SendingConductor(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        this.locator = new ReportLocator(this.context);
    }

    public final void sendReports(boolean foreground, @NotNull Bundle extras) {
        Object object;
        ACRALog aCRALog;
        String string;
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            object = "About to start sending reports from SenderService";
            aCRALog.d(string, (String)object);
        }
        try {
            String toast;
            List senderInstances = CollectionsKt.toMutableList((Collection)this.getSenderInstances(foreground));
            if (senderInstances.isEmpty()) {
                boolean $i$f$debug2 = false;
                if (ACRA.DEV_LOGGING) {
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    object = "No ReportSenders configured - adding NullSender";
                    aCRALog.d(string, (String)object);
                }
                senderInstances.add(new NullSender());
            }
            File[] reports = this.locator.getApprovedReports();
            ReportDistributor reportDistributor = new ReportDistributor(this.context, this.config, senderInstances, extras);
            int reportsSentCount = 0;
            CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
            boolean anyNonSilent = false;
            for (File report : reports) {
                boolean isNonSilent;
                String string2 = report.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"report.name");
                boolean bl = isNonSilent = !fileNameParser.isSilent(string2);
                if (extras.getBoolean("onlySendSilentReports") && isNonSilent) continue;
                anyNonSilent |= isNonSilent;
                if (reportsSentCount >= 5) break;
                if (!reportDistributor.distribute(report)) continue;
                int n = reportsSentCount;
                reportsSentCount = n + 1;
            }
            String string3 = toast = reportsSentCount > 0 ? this.config.getReportSendSuccessToast() : this.config.getReportSendFailureToast();
            if (anyNonSilent && toast != null && ((CharSequence)toast).length() > 0) {
                boolean $i$f$debug3 = false;
                if (ACRA.DEV_LOGGING) {
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    object = "About to show " + (reportsSentCount > 0 ? "success" : "failure") + " toast";
                    aCRALog.d(string, (String)object);
                }
                new Handler(Looper.getMainLooper()).post(() -> SendingConductor.sendReports$lambda$3(this, toast));
            }
        }
        catch (Exception e) {
            boolean $i$f$error = false;
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            object = "";
            aCRALog.e(string, (String)object, e);
        }
        $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            object = "Finished sending reports from SenderService";
            aCRALog.d(string, (String)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ReportSender> getSenderInstances(boolean foreground) {
        void $this$filterTo$iv$iv;
        ReportSender it;
        Iterable $this$mapTo$iv$iv;
        void $this$loadEnabled$iv;
        Object object;
        Object object2;
        String string;
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string = ACRA.LOG_TAG;
            object2 = ACRA.log;
            boolean bl = false;
            object = "Using PluginLoader to find ReportSender factories";
            object2.d(string, (String)object);
        }
        PluginLoader bl = this.config.getPluginLoader();
        CoreConfiguration config$iv = this.config;
        boolean $i$f$loadEnabled22 = false;
        List<ReportSenderFactory> factories = $this$loadEnabled$iv.loadEnabled(config$iv, ReportSenderFactory.class);
        boolean $i$f$debug2 = false;
        if (ACRA.DEV_LOGGING) {
            string = ACRA.LOG_TAG;
            object2 = ACRA.log;
            boolean bl2 = false;
            object = "reportSenderFactories : " + factories;
            object2.d(string, (String)object);
        }
        Iterable $this$map$iv = factories;
        boolean $i$f$map = false;
        Iterable $i$f$loadEnabled22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ReportSender reportSender;
            ReportSenderFactory reportSenderFactory = (ReportSenderFactory)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl3 = false;
            ReportSender it2 = reportSender = it.create(this.context, this.config);
            boolean bl4 = false;
            boolean $i$f$debug3 = false;
            if (ACRA.DEV_LOGGING) {
                String string2 = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl5 = false;
                String string3 = "Adding reportSender : " + it2;
                aCRALog.d(string2, string3);
            }
            object2.add(reportSender);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ReportSender)element$iv$iv;
            boolean bl6 = false;
            if (!(foreground == it.requiresForeground())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void sendReports$lambda$3(SendingConductor this$0, String $toast) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ToastSender.sendToast(this$0.context, $toast, 1);
    }
}

