/*
 * Decompiled with CFR 0.152.
 */
package org.acra.data;

import android.content.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.builder.ReportBuilder;
import org.acra.collector.ApplicationStartupCollector;
import org.acra.collector.Collector;
import org.acra.collector.CollectorException;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/acra/data/CrashReportDataFactory;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "collectors", "", "Lorg/acra/collector/Collector;", "safeOrder", "Lorg/acra/collector/Collector$Order;", "getSafeOrder", "(Lorg/acra/collector/Collector;)Lorg/acra/collector/Collector$Order;", "collect", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "builder", "Lorg/acra/builder/ReportBuilder;", "crashReportData", "Lorg/acra/data/CrashReportData;", "collectStartUp", "createCrashData", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nCrashReportDataFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashReportDataFactory.kt\norg/acra/data/CrashReportDataFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,103:1\n1045#2:104\n1477#2:105\n1502#2,3:106\n1505#2,3:116\n1549#2:125\n1620#2,3:126\n361#3,7:109\n215#4:119\n216#4:124\n7#5,2:120\n7#5,2:122\n19#5,2:129\n7#5,2:131\n7#5,2:133\n19#5,2:135\n19#5,2:137\n*S KotlinDebug\n*F\n+ 1 CrashReportDataFactory.kt\norg/acra/data/CrashReportDataFactory\n*L\n37#1:104\n55#1:105\n55#1:106,3\n55#1:116,3\n64#1:125\n64#1:126,3\n55#1:109,7\n55#1:119\n55#1:124\n56#1:120,2\n58#1:122,2\n97#1:129,2\n68#1:131,2\n70#1:133,2\n72#1:135,2\n74#1:137,2\n*E\n"})
public final class CrashReportDataFactory {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final List<Collector> collectors;

    public CrashReportDataFactory(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        Iterable $this$sortedBy$iv = this.config.getPluginLoader().loadEnabled(this.config, Collector.class);
        boolean $i$f$sortedBy = false;
        this.collectors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
            final /* synthetic */ CrashReportDataFactory this$0;
            {
                this.this$0 = crashReportDataFactory;
            }

            public final int compare(T a, T b) {
                Collector it = (Collector)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)CrashReportDataFactory.access$getSafeOrder(this.this$0, it));
                it = (Collector)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)CrashReportDataFactory.access$getSafeOrder(this.this$0, it))));
            }
        });
    }

    private final Collector.Order getSafeOrder(Collector $this$safeOrder) {
        Collector.Order order;
        try {
            order = $this$safeOrder.getOrder();
        }
        catch (Exception t) {
            order = Collector.Order.NORMAL;
        }
        return order;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CrashReportData createCrashData(@NotNull ReportBuilder builder) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ExecutorService executorService = this.config.getParallel() ? Executors.newCachedThreadPool() : Executors.newSingleThreadExecutor();
        CrashReportData crashReportData = new CrashReportData();
        Iterable $this$groupBy$iv = this.collectors;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Collector it = (Collector)element$iv$iv;
            boolean bl = false;
            Collector.Order key$iv$iv = this.getSafeOrder(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = MapsKt.toSortedMap((Map)destination$iv$iv);
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            String string;
            ACRALog aCRALog;
            String string2;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            Collector.Order order = (Collector.Order)((Object)entry.getKey());
            List collectors = (List)entry.getValue();
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl3 = false;
                string = "Starting collectors with priority " + order.name();
                aCRALog.d(string2, string);
            }
            Intrinsics.checkNotNullExpressionValue((Object)collectors, (String)"collectors");
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executorService");
            this.collect(collectors, executorService, builder, crashReportData);
            $i$f$debug = false;
            if (!ACRA.DEV_LOGGING) continue;
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl4 = false;
            string = "Finished collectors with priority " + order.name();
            aCRALog.d(string2, string);
        }
        return crashReportData;
    }

    /*
     * WARNING - void declaration
     */
    private final void collect(List<? extends Collector> collectors, ExecutorService executorService, ReportBuilder builder, CrashReportData crashReportData) {
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = collectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void collector;
            Collector collector2 = (Collector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(executorService.submit(() -> CrashReportDataFactory.collect$lambda$10$lambda$9((Collector)collector, this, builder, crashReportData)));
        }
        List futures = (List)destination$iv$iv;
        block4: for (Future future : futures) {
            while (!future.isDone()) {
                try {
                    future.get();
                }
                catch (InterruptedException $this$mapTo$iv$iv2) {
                }
                catch (ExecutionException e) {
                    continue block4;
                }
            }
        }
    }

    public final void collectStartUp() {
        for (Collector collector : this.collectors) {
            if (!(collector instanceof ApplicationStartupCollector)) continue;
            try {
                ((ApplicationStartupCollector)collector).collectApplicationStartUp(this.context, this.config);
            }
            catch (Throwable t) {
                boolean $i$f$warn = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = collector.getClass().getSimpleName() + " failed to collect its startup data";
                aCRALog.w(string, string2, t);
            }
        }
    }

    private static final void collect$lambda$10$lambda$9(Collector $collector, CrashReportDataFactory this$0, ReportBuilder $builder, CrashReportData $crashReportData) {
        Intrinsics.checkNotNullParameter((Object)$collector, (String)"$collector");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)$crashReportData, (String)"$crashReportData");
        try {
            String string;
            ACRALog aCRALog;
            String string2;
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Calling collector " + $collector.getClass().getName();
                aCRALog.d(string2, string);
            }
            $collector.collect(this$0.context, this$0.config, $builder, $crashReportData);
            $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Collector " + $collector.getClass().getName() + " completed";
                aCRALog.d(string2, string);
            }
        }
        catch (CollectorException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string3 = "";
            aCRALog.w(string, string3, e);
        }
        catch (Throwable t) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string4 = "Error in collector " + $collector.getClass().getSimpleName();
            aCRALog.w(string, string4, t);
        }
    }

    public static final /* synthetic */ Collector.Order access$getSafeOrder(CrashReportDataFactory $this, Collector $receiver) {
        return $this.getSafeOrder($receiver);
    }
}

