/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import com.google.auto.service.AutoService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/acra/collector/ThreadCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "acra-core_release"})
@AutoService(value={Collector.class})
@SourceDebugExtension(value={"SMAP\nThreadCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadCollector.kt\norg/acra/collector/ThreadCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public class ThreadCollector
extends BaseReportFieldCollector {
    public ThreadCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.THREAD_DETAILS};
        super(reportFieldArray);
    }

    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.LATE;
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Thread t = reportBuilder.getUncaughtExceptionThread();
        if (t != null) {
            JSONObject result = new JSONObject();
            result.put("id", t.getId());
            result.put("name", (Object)t.getName());
            result.put("priority", t.getPriority());
            ThreadGroup threadGroup = t.getThreadGroup();
            if (threadGroup != null) {
                ThreadGroup it = threadGroup;
                boolean bl = false;
                result.put("groupName", (Object)it);
            }
            target.put(ReportField.THREAD_DETAILS, result);
        } else {
            target.put(ReportField.THREAD_DETAILS, (String)null);
        }
    }
}

