/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.google.auto.service.AutoService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00042\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0012\u00a8\u0006\u0016"}, d2={"Lorg/acra/collector/ReflectionCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectStaticGettersResults", "someClass", "Ljava/lang/Class;", "container", "Lorg/json/JSONObject;", "getBuildConfigClass", "Companion", "acra-core_release"})
@AutoService(value={Collector.class})
public class ReflectionCollector
extends BaseReportFieldCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ReflectionCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.BUILD, ReportField.BUILD_CONFIG, ReportField.ENVIRONMENT};
        super(reportFieldArray);
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws JSONException, ClassNotFoundException {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        JSONObject result = new JSONObject();
        switch (WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                ReflectionCollector.Companion.collectConstants(Build.class, result, CollectionsKt.listOf((Object)"SERIAL"));
                JSONObject version = new JSONObject();
                org.acra.collector.ReflectionCollector$Companion.collectConstants$default(Companion, Build.VERSION.class, version, null, 4, null);
                result.put("VERSION", (Object)version);
                break;
            }
            case 2: {
                org.acra.collector.ReflectionCollector$Companion.collectConstants$default(Companion, this.getBuildConfigClass(context, config), result, null, 4, null);
                break;
            }
            case 3: {
                this.collectStaticGettersResults(Environment.class, result);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        target.put(reportField, result);
    }

    private void collectStaticGettersResults(Class<?> someClass, JSONObject container) throws JSONException {
        Method[] methods = someClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
        for (Method method : methods) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"method.parameterTypes");
            if (!(((Object[])classArray).length == 0)) continue;
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            if (!StringsKt.startsWith$default((String)string, (String)"get", (boolean)false, (int)2, null)) {
                string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
                if (!StringsKt.startsWith$default((String)string, (String)"is", (boolean)false, (int)2, null)) continue;
            }
            if (Intrinsics.areEqual((Object)"getClass", (Object)method.getName())) continue;
            try {
                container.put(method.getName(), method.invoke(null, new Object[0]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private Class<?> getBuildConfigClass(Context context, CoreConfiguration config) throws ClassNotFoundException {
        Class<?> clazz = config.getBuildConfigClass();
        if (clazz == null) {
            Class<?> clazz2 = Class.forName(context.getPackageName() + ".BuildConfig");
            clazz = clazz2;
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"forName(context.packageName + \".BuildConfig\")");
        }
        return clazz;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/acra/collector/ReflectionCollector$Companion;", "", "()V", "collectConstants", "", "someClass", "Ljava/lang/Class;", "container", "Lorg/json/JSONObject;", "exclude", "", "", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void collectConstants(Class<?> someClass, JSONObject container, Collection<String> exclude) throws JSONException {
            Field[] fields = someClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
            for (Field field : fields) {
                if (exclude.contains(field.getName())) continue;
                try {
                    Object value = field.get(null);
                    if (value == null) continue;
                    if (field.getType().isArray()) {
                        Object[] objectArray = (Object[])value;
                        container.put(field.getName(), (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])Arrays.copyOf(objectArray, objectArray.length))));
                        continue;
                    }
                    container.put(field.getName(), value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ void collectConstants$default(Companion companion, Class clazz, JSONObject jSONObject, Collection collection, int n, Object object) throws JSONException {
            if ((n & 4) != 0) {
                collection = CollectionsKt.emptyList();
            }
            companion.collectConstants(clazz, jSONObject, collection);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportField.values().length];
            try {
                nArray[ReportField.BUILD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportField.BUILD_CONFIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportField.ENVIRONMENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

