/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.SparseArray;
import com.google.auto.service.AutoService;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 )2\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0013J\b\u0010\"\u001a\u00020\u001eH\u0013J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001f\u001a\u00020 H\u0013J\b\u0010%\u001a\u00020\u0012H\u0012J(\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lorg/acra/collector/MediaCodecListCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "mAACProfileValues", "Landroid/util/SparseArray;", "", "mAVCLevelValues", "mAVCProfileValues", "mColorFormatValues", "mH263LevelValues", "mH263ProfileValues", "mMPEG4LevelValues", "mMPEG4ProfileValues", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectCapabilitiesForType", "Lorg/json/JSONObject;", "codecInfo", "Landroid/media/MediaCodecInfo;", "type", "collectMediaCodecList", "identifyCodecType", "Lorg/acra/collector/MediaCodecListCollector$CodecType;", "prepare", "shouldCollect", "", "CodecType", "Companion", "acra-core_release"})
@AutoService(value={Collector.class})
public class MediaCodecListCollector
extends BaseReportFieldCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArray<String> mColorFormatValues;
    @NotNull
    private final SparseArray<String> mAVCLevelValues;
    @NotNull
    private final SparseArray<String> mAVCProfileValues;
    @NotNull
    private final SparseArray<String> mH263LevelValues;
    @NotNull
    private final SparseArray<String> mH263ProfileValues;
    @NotNull
    private final SparseArray<String> mMPEG4LevelValues;
    @NotNull
    private final SparseArray<String> mMPEG4ProfileValues;
    @NotNull
    private final SparseArray<String> mAACProfileValues;
    @NotNull
    private static final String COLOR_FORMAT_PREFIX = "COLOR_";
    @NotNull
    private static final String[] MPEG4_TYPES;
    @NotNull
    private static final String[] AVC_TYPES;
    @NotNull
    private static final String[] H263_TYPES;
    @NotNull
    private static final String[] AAC_TYPES;

    public MediaCodecListCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.MEDIA_CODEC_LIST};
        super(reportFieldArray);
        this.mColorFormatValues = new SparseArray();
        this.mAVCLevelValues = new SparseArray();
        this.mAVCProfileValues = new SparseArray();
        this.mH263LevelValues = new SparseArray();
        this.mH263ProfileValues = new SparseArray();
        this.mMPEG4LevelValues = new SparseArray();
        this.mMPEG4ProfileValues = new SparseArray();
        this.mAACProfileValues = new SparseArray();
    }

    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.LATE;
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.put(ReportField.MEDIA_CODEC_LIST, this.collectMediaCodecList());
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)collect), (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return super.shouldCollect(context, config, collect, reportBuilder) && Build.VERSION.SDK_INT >= 16;
    }

    private void prepare() {
        try {
            Class<?> codecCapabilitiesClass = Class.forName("android.media.MediaCodecInfo$CodecCapabilities");
            Field[] fieldArray = codecCapabilitiesClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"codecCapabilitiesClass.fields");
            Field[] fieldArray2 = fieldArray;
            int n = fieldArray2.length;
            for (int i = 0; i < n; ++i) {
                Field f = fieldArray2[i];
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
                if (!StringsKt.startsWith$default((String)string, (String)COLOR_FORMAT_PREFIX, (boolean)false, (int)2, null)) continue;
                this.mColorFormatValues.put(f.getInt(null), (Object)f.getName());
            }
            Class<?> codecProfileLevelClass = Class.forName("android.media.MediaCodecInfo$CodecProfileLevel");
            Field[] fieldArray3 = codecProfileLevelClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray3, (String)"codecProfileLevelClass.fields");
            for (Field f : fieldArray3) {
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
                if (StringsKt.startsWith$default((String)string, (String)"AVCLevel", (boolean)false, (int)2, null)) {
                    this.mAVCLevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string2 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"f.name");
                if (StringsKt.startsWith$default((String)string2, (String)"AVCProfile", (boolean)false, (int)2, null)) {
                    this.mAVCProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string3 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"f.name");
                if (StringsKt.startsWith$default((String)string3, (String)"H263Level", (boolean)false, (int)2, null)) {
                    this.mH263LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string4 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"f.name");
                if (StringsKt.startsWith$default((String)string4, (String)"H263Profile", (boolean)false, (int)2, null)) {
                    this.mH263ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string5 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"f.name");
                if (StringsKt.startsWith$default((String)string5, (String)"MPEG4Level", (boolean)false, (int)2, null)) {
                    this.mMPEG4LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string6 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"f.name");
                if (StringsKt.startsWith$default((String)string6, (String)"MPEG4Profile", (boolean)false, (int)2, null)) {
                    this.mMPEG4ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string7 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"f.name");
                if (!StringsKt.startsWith$default((String)string7, (String)"AAC", (boolean)false, (int)2, null)) continue;
                this.mAACProfileValues.put(f.getInt(null), (Object)f.getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TargetApi(value=16)
    private JSONObject collectMediaCodecList() throws JSONException {
        this.prepare();
        MediaCodecInfo[] infos = null;
        if (Build.VERSION.SDK_INT < 21) {
            int codecCount = MediaCodecList.getCodecCount();
            infos = new MediaCodecInfo[codecCount];
            for (int codecIdx = 0; codecIdx < codecCount; ++codecIdx) {
                infos[codecIdx] = MediaCodecList.getCodecInfoAt((int)codecIdx);
            }
        } else {
            MediaCodecInfo[] mediaCodecInfoArray = new MediaCodecList(1).getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"MediaCodecList(MediaCode\u2026st.ALL_CODECS).codecInfos");
            infos = mediaCodecInfoArray;
        }
        JSONObject result = new JSONObject();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            MediaCodecInfo codecInfo = infos[i];
            JSONObject codec = new JSONObject();
            MediaCodecInfo mediaCodecInfo = codecInfo;
            Intrinsics.checkNotNull((Object)mediaCodecInfo);
            String[] supportedTypes = mediaCodecInfo.getSupportedTypes();
            codec.put("name", (Object)codecInfo.getName()).put("isEncoder", codecInfo.isEncoder());
            JSONObject supportedTypesJson = new JSONObject();
            Intrinsics.checkNotNullExpressionValue((Object)supportedTypes, (String)"supportedTypes");
            for (String type : supportedTypes) {
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                supportedTypesJson.put(type, (Object)this.collectCapabilitiesForType(codecInfo, type));
            }
            codec.put("supportedTypes", (Object)supportedTypesJson);
            result.put(String.valueOf(i), (Object)codec);
        }
        return result;
    }

    @TargetApi(value=16)
    private JSONObject collectCapabilitiesForType(MediaCodecInfo codecInfo, String type) throws JSONException {
        JSONObject result = new JSONObject();
        MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
        int[] colorFormats = codecCapabilities.colorFormats;
        Intrinsics.checkNotNullExpressionValue((Object)colorFormats, (String)"colorFormats");
        if (!(colorFormats.length == 0)) {
            JSONArray colorFormatsJson = new JSONArray();
            for (int colorFormat : colorFormats) {
                colorFormatsJson.put(this.mColorFormatValues.get(colorFormat));
            }
            result.put("colorFormats", (Object)colorFormatsJson);
        }
        CodecType codecType = this.identifyCodecType(codecInfo);
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevels = codecCapabilities.profileLevels;
        Intrinsics.checkNotNullExpressionValue((Object)codecProfileLevels, (String)"codecProfileLevels");
        if (!(codecProfileLevels.length == 0)) {
            JSONArray profileLevels = new JSONArray();
            block7: for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecProfileLevels) {
                int profileValue = codecProfileLevel.profile;
                int levelValue = codecProfileLevel.level;
                if (codecType == null) {
                    profileLevels.put(profileValue + 45 + levelValue);
                    break;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[codecType.ordinal()]) {
                    case 1: {
                        profileLevels.put((Object)("" + profileValue + this.mAVCProfileValues.get(profileValue) + "-" + this.mAVCLevelValues.get(levelValue)));
                        continue block7;
                    }
                    case 2: {
                        profileLevels.put((Object)(this.mH263ProfileValues.get(profileValue) + "-" + this.mH263LevelValues.get(levelValue)));
                        continue block7;
                    }
                    case 3: {
                        profileLevels.put((Object)(this.mMPEG4ProfileValues.get(profileValue) + "-" + this.mMPEG4LevelValues.get(levelValue)));
                        continue block7;
                    }
                    case 4: {
                        profileLevels.put(this.mAACProfileValues.get(profileValue));
                    }
                }
            }
            result.put("profileLevels", (Object)profileLevels);
        }
        return result;
    }

    @TargetApi(value=16)
    private CodecType identifyCodecType(MediaCodecInfo codecInfo) {
        String string = codecInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codecInfo.name");
        String name = string;
        for (String token : AVC_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.AVC;
        }
        for (String token : H263_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.H263;
        }
        for (String token : MPEG4_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.MPEG4;
        }
        for (String token : AAC_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.AAC;
        }
        return null;
    }

    static {
        String[] stringArray = new String[]{"mp4", "mpeg4", "MP4", "MPEG4"};
        MPEG4_TYPES = stringArray;
        stringArray = new String[]{"avc", "h264", "AVC", "H264"};
        AVC_TYPES = stringArray;
        stringArray = new String[]{"h263", "H263"};
        H263_TYPES = stringArray;
        stringArray = new String[]{"aac", "AAC"};
        AAC_TYPES = stringArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/acra/collector/MediaCodecListCollector$CodecType;", "", "(Ljava/lang/String;I)V", "AVC", "H263", "MPEG4", "AAC", "acra-core_release"})
    private static final class CodecType
    extends Enum<CodecType> {
        public static final /* enum */ CodecType AVC = new CodecType();
        public static final /* enum */ CodecType H263 = new CodecType();
        public static final /* enum */ CodecType MPEG4 = new CodecType();
        public static final /* enum */ CodecType AAC = new CodecType();
        private static final /* synthetic */ CodecType[] $VALUES;

        public static CodecType[] values() {
            return (CodecType[])$VALUES.clone();
        }

        public static CodecType valueOf(String value) {
            return Enum.valueOf(CodecType.class, value);
        }

        static {
            $VALUES = codecTypeArray = new CodecType[]{CodecType.AVC, CodecType.H263, CodecType.MPEG4, CodecType.AAC};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/acra/collector/MediaCodecListCollector$Companion;", "", "()V", "AAC_TYPES", "", "", "[Ljava/lang/String;", "AVC_TYPES", "COLOR_FORMAT_PREFIX", "H263_TYPES", "MPEG4_TYPES", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodecType.values().length];
            try {
                nArray[CodecType.AVC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodecType.H263.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodecType.MPEG4.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodecType.AAC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

