/*
 * Decompiled with CFR 0.152.
 */
package org.acra.builder;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.collections.WeakStack;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/acra/builder/LastActivityManager;", "", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "activityStack", "Lorg/acra/collections/WeakStack;", "Landroid/app/Activity;", "destroyedCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "lastActivities", "", "getLastActivities", "()Ljava/util/List;", "lastActivity", "getLastActivity", "()Landroid/app/Activity;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "clearLastActivities", "", "waitForAllActivitiesDestroy", "timeOutInMillis", "", "acra-core_release"})
public final class LastActivityManager {
    @NotNull
    private final WeakStack<Activity> activityStack;
    @NotNull
    private final ReentrantLock lock;
    private final Condition destroyedCondition;

    public LastActivityManager(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.activityStack = new WeakStack();
        this.lock = new ReentrantLock();
        this.destroyedCondition = this.lock.newCondition();
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "onActivityCreated " + activity.getClass();
                    aCRALog.d(string, string2);
                }
                activityStack.add(activity);
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "onActivityStarted " + activity.getClass();
                    aCRALog.d(string, string2);
                }
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "onActivityResumed " + activity.getClass();
                    aCRALog.d(string, string2);
                }
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "onActivityPaused " + activity.getClass();
                    aCRALog.d(string, string2);
                }
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "onActivityStopped " + activity.getClass();
                    aCRALog.d(string, string2);
                }
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "onActivitySaveInstanceState " + activity.getClass();
                    aCRALog.d(string, string2);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "onActivityDestroyed " + activity.getClass();
                    aCRALog.d(string, string2);
                }
                Lock lock = lock;
                LastActivityManager lastActivityManager = this;
                lock.lock();
                try {
                    boolean bl = false;
                    lastActivityManager.activityStack.remove(activity);
                    lastActivityManager.destroyedCondition.signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        });
    }

    @Nullable
    public final Activity getLastActivity() {
        return this.activityStack.isEmpty() ? null : this.activityStack.peek();
    }

    @NotNull
    public final List<Activity> getLastActivities() {
        return new ArrayList((Collection)this.activityStack);
    }

    public final void clearLastActivities() {
        this.activityStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForAllActivitiesDestroy(int timeOutInMillis) {
        Lock lock = this.lock;
        lock.lock();
        try {
            long start;
            boolean bl = false;
            long now = start = System.currentTimeMillis();
            while (!this.activityStack.isEmpty() && start + (long)timeOutInMillis > now) {
                this.destroyedCondition.await(start - now + (long)timeOutInMillis, TimeUnit.MILLISECONDS);
                now = System.currentTimeMillis();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }
}

