/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.app.ActivityManager;
import android.app.NotificationManager;
import android.content.Context;
import android.os.DropBoxManager;
import android.telephony.TelephonyManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/acra/util/SystemServices;", "", "()V", "getActivityManager", "Landroid/app/ActivityManager;", "context", "Landroid/content/Context;", "getDropBoxManager", "Landroid/os/DropBoxManager;", "getNotificationManager", "Landroid/app/NotificationManager;", "getService", "id", "", "getTelephonyManager", "Landroid/telephony/TelephonyManager;", "ServiceNotReachedException", "acra-core_release"})
public final class SystemServices {
    @NotNull
    public static final SystemServices INSTANCE = new SystemServices();

    private SystemServices() {
    }

    @JvmStatic
    @NotNull
    public static final TelephonyManager getTelephonyManager(@NotNull Context context) throws ServiceNotReachedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (TelephonyManager)INSTANCE.getService(context, "phone");
    }

    @JvmStatic
    @NotNull
    public static final DropBoxManager getDropBoxManager(@NotNull Context context) throws ServiceNotReachedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (DropBoxManager)INSTANCE.getService(context, "dropbox");
    }

    @JvmStatic
    @NotNull
    public static final NotificationManager getNotificationManager(@NotNull Context context) throws ServiceNotReachedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (NotificationManager)INSTANCE.getService(context, "notification");
    }

    @JvmStatic
    @NotNull
    public static final ActivityManager getActivityManager(@NotNull Context context) throws ServiceNotReachedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (ActivityManager)INSTANCE.getService(context, "activity");
    }

    private final Object getService(Context context, String id) throws ServiceNotReachedException {
        Object object = context.getSystemService(id);
        if (object == null) {
            throw new ServiceNotReachedException(Intrinsics.stringPlus((String)"Unable to load SystemService ", (Object)id));
        }
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/acra/util/SystemServices$ServiceNotReachedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "acra-core_release"})
    public static final class ServiceNotReachedException
    extends Exception {
        public ServiceNotReachedException(@Nullable String message) {
            super(message);
        }
    }
}

