/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import com.google.auto.service.AutoService;
import java.lang.reflect.Field;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010#\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010$\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010%\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\bH\u0002\u00a8\u0006+"}, d2={"Lorg/acra/collector/DisplayManagerCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "activeFlags", "", "flagNames", "Landroid/util/SparseArray;", "bitfield", "", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectCurrentSizeRange", "display", "Landroid/view/Display;", "container", "Lorg/json/JSONObject;", "collectDisplayData", "collectFlags", "collectIsValid", "collectMetrics", "metrics", "Landroid/util/DisplayMetrics;", "collectName", "collectRealMetrics", "collectRealSize", "collectRectSize", "collectRotation", "collectSize", "getDisplays", "", "(Landroid/content/Context;)[Landroid/view/Display;", "rotationToString", "rotation", "acra-core_release"})
@AutoService(value={Collector.class})
public class DisplayManagerCollector
extends BaseReportFieldCollector {
    public DisplayManagerCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.DISPLAY};
        super(reportFieldArray);
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        JSONObject result = new JSONObject();
        Display[] displayArray = this.getDisplays(context);
        int n = 0;
        int n2 = displayArray.length;
        while (n < n2) {
            Display display = displayArray[n];
            ++n;
            try {
                result.put(String.valueOf(display.getDisplayId()), (Object)this.collectDisplayData(display));
            }
            catch (JSONException e) {
                ACRA.log.w(ACRA.LOG_TAG, Intrinsics.stringPlus((String)"Failed to collect data for display ", (Object)display.getDisplayId()), e);
            }
        }
        target.put(ReportField.DISPLAY, result);
    }

    private final Display[] getDisplays(Context context) {
        Display[] displayArray;
        if (Build.VERSION.SDK_INT >= 17) {
            Object object = context.getSystemService("display");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
            }
            Display[] displayArray2 = ((DisplayManager)object).getDisplays();
            Intrinsics.checkNotNullExpressionValue((Object)displayArray2, (String)"{\n            (context.getSystemService(Context.DISPLAY_SERVICE) as DisplayManager).displays\n        }");
            displayArray = displayArray2;
        } else {
            Display[] displayArray3 = new Display[1];
            Object object = context.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            Display display = ((WindowManager)object).getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"context.getSystemService(Context.WINDOW_SERVICE) as WindowManager).defaultDisplay");
            displayArray3[0] = display;
            displayArray = displayArray3;
        }
        return displayArray;
    }

    private final JSONObject collectDisplayData(Display display) throws JSONException {
        display.getMetrics(new DisplayMetrics());
        JSONObject result = new JSONObject();
        this.collectCurrentSizeRange(display, result);
        this.collectFlags(display, result);
        this.collectMetrics(display, result);
        this.collectRealMetrics(display, result);
        this.collectName(display, result);
        this.collectRealSize(display, result);
        this.collectRectSize(display, result);
        this.collectSize(display, result);
        this.collectRotation(display, result);
        this.collectIsValid(display, result);
        result.put("orientation", display.getRotation()).put("refreshRate", (double)display.getRefreshRate()).put("height", display.getHeight()).put("width", display.getWidth()).put("pixelFormat", display.getPixelFormat());
        return result;
    }

    private final void collectIsValid(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            container.put("isValid", display.isValid());
        }
    }

    private final void collectRotation(Display display, JSONObject container) throws JSONException {
        container.put("rotation", (Object)this.rotationToString(display.getRotation()));
    }

    private final String rotationToString(int rotation) {
        String string;
        int n = rotation;
        switch (n) {
            case 0: {
                string = "ROTATION_0";
                break;
            }
            case 1: {
                string = "ROTATION_90";
                break;
            }
            case 2: {
                string = "ROTATION_180";
                break;
            }
            case 3: {
                string = "ROTATION_270";
                break;
            }
            default: {
                string = String.valueOf(rotation);
            }
        }
        return string;
    }

    private final void collectRectSize(Display display, JSONObject container) throws JSONException {
        Object[] objectArray = new Rect();
        boolean bl = false;
        boolean bl2 = false;
        Object[] it = objectArray;
        boolean bl3 = false;
        display.getRectSize((Rect)it);
        Object[] size = objectArray;
        objectArray = new Integer[]{size.top, size.left, size.width(), size.height()};
        container.put("rectSize", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])objectArray)));
    }

    private final void collectSize(Display display, JSONObject container) throws JSONException {
        Object[] objectArray = new Point();
        boolean bl = false;
        boolean bl2 = false;
        Object[] it = objectArray;
        boolean bl3 = false;
        display.getSize((Point)it);
        Object[] size = objectArray;
        objectArray = new Integer[]{size.x, size.y};
        container.put("size", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])objectArray)));
    }

    private final void collectRealSize(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            Object[] objectArray = new Point();
            boolean bl = false;
            boolean bl2 = false;
            Object[] it = objectArray;
            boolean bl3 = false;
            display.getRealSize((Point)it);
            Object[] size = objectArray;
            objectArray = new Integer[]{size.x, size.y};
            container.put("realSize", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])objectArray)));
        }
    }

    private final void collectCurrentSizeRange(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 16) {
            Point smallest = new Point();
            Point largest = new Point();
            display.getCurrentSizeRange(smallest, largest);
            JSONObject result = new JSONObject();
            Object[] objectArray = new Integer[]{smallest.x, smallest.y};
            result.put("smallest", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])objectArray)));
            objectArray = new Integer[]{largest.x, largest.y};
            result.put("largest", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])objectArray)));
            container.put("currentSizeRange", (Object)result);
        }
    }

    private final void collectFlags(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            SparseArray flagNames = new SparseArray();
            int flags = display.getFlags();
            Field[] fieldArray = display.getClass().getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"display.javaClass.fields");
            Field[] fieldArray2 = fieldArray;
            int n = 0;
            int n2 = fieldArray2.length;
            while (n < n2) {
                Field field = fieldArray2[n];
                ++n;
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                if (!StringsKt.startsWith$default((String)string, (String)"FLAG_", (boolean)false, (int)2, null)) continue;
                try {
                    flagNames.put(field.getInt(null), (Object)field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            container.put("flags", (Object)this.activeFlags((SparseArray<String>)flagNames, flags));
        }
    }

    private final void collectName(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            container.put("name", (Object)display.getName());
        }
    }

    private final void collectMetrics(Display display, JSONObject container) throws JSONException {
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        JSONObject result = new JSONObject();
        this.collectMetrics(metrics, result);
        container.put("metrics", (Object)result);
    }

    private final void collectRealMetrics(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            display.getRealMetrics(metrics);
            JSONObject result = new JSONObject();
            this.collectMetrics(metrics, result);
            container.put("realMetrics", (Object)result);
        }
    }

    private final void collectMetrics(DisplayMetrics metrics, JSONObject container) throws JSONException {
        container.put("density", (double)metrics.density).put("densityDpi", metrics.densityDpi).put("scaledDensity", (Object)Intrinsics.stringPlus((String)"x", (Object)Float.valueOf(metrics.scaledDensity))).put("widthPixels", metrics.widthPixels).put("heightPixels", metrics.heightPixels).put("xdpi", (double)metrics.xdpi).put("ydpi", (double)metrics.ydpi);
    }

    private final String activeFlags(SparseArray<String> flagNames, int bitfield) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        int n2 = flagNames.size();
        if (n < n2) {
            do {
                int i;
                int maskValue;
                int value;
                if ((value = bitfield & (maskValue = flagNames.keyAt(i = n++))) <= 0) continue;
                CharSequence charSequence = result;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    result.append('+');
                }
                result.append((String)flagNames.get(value));
            } while (n < n2);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }
}

