/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.res.Configuration;
import android.util.SparseArray;
import com.google.auto.service.AutoService;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.ApplicationStartupCollector;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.collector.ConfigurationCollector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0002%&B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J2\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0 H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/acra/collector/ConfigurationCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "Lorg/acra/collector/ApplicationStartupCollector;", "()V", "initialConfiguration", "Lorg/json/JSONObject;", "activeFlags", "", "valueNames", "Landroid/util/SparseArray;", "bitfield", "", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectApplicationStartUp", "collectConfiguration", "configToJson", "conf", "Landroid/content/res/Configuration;", "getFieldValueName", "", "valueArrays", "", "Lorg/acra/collector/ConfigurationCollector$Prefix;", "f", "Ljava/lang/reflect/Field;", "getValueArrays", "Companion", "Prefix", "acra-core_release"})
@AutoService(value={Collector.class})
public class ConfigurationCollector
extends BaseReportFieldCollector
implements ApplicationStartupCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private JSONObject initialConfiguration;
    @NotNull
    private static final String SUFFIX_MASK = "_MASK";
    @NotNull
    private static final String FIELD_SCREENLAYOUT = "screenLayout";
    @NotNull
    private static final String FIELD_UIMODE = "uiMode";
    @NotNull
    private static final String FIELD_MNC = "mnc";
    @NotNull
    private static final String FIELD_MCC = "mcc";

    public ConfigurationCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.INITIAL_CONFIGURATION, ReportField.CRASH_CONFIGURATION};
        super(reportFieldArray);
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ReportField reportField2 = reportField;
        int n = WhenMappings.$EnumSwitchMapping$0[reportField2.ordinal()];
        switch (n) {
            case 1: {
                target.put(ReportField.INITIAL_CONFIGURATION, this.initialConfiguration);
                break;
            }
            case 2: {
                target.put(ReportField.CRASH_CONFIGURATION, this.collectConfiguration(context));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void collectApplicationStartUp(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.getReportContent().contains(ReportField.INITIAL_CONFIGURATION)) {
            this.initialConfiguration = this.collectConfiguration(context);
        }
    }

    private final JSONObject configToJson(Configuration conf) {
        JSONObject result = new JSONObject();
        Map<Prefix, SparseArray<String>> valueArrays = this.getValueArrays();
        Field[] fieldArray = conf.getClass().getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"conf.javaClass.fields");
        Field[] fieldArray2 = fieldArray;
        int n = 0;
        int n2 = fieldArray2.length;
        while (n < n2) {
            String string;
            ACRALog aCRALog;
            String string2;
            Field f = fieldArray2[n];
            ++n;
            try {
                if (Modifier.isStatic(f.getModifiers())) continue;
                String fieldName = f.getName();
                try {
                    if (Intrinsics.areEqual(f.getType(), Integer.TYPE)) {
                        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                        result.put(fieldName, this.getFieldValueName(valueArrays, conf, f));
                        continue;
                    }
                    if (f.get(conf) == null) continue;
                    result.put(fieldName, f.get(conf));
                }
                catch (JSONException e) {
                    boolean $i$f$warn = false;
                    string2 = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    string = Intrinsics.stringPlus((String)"Could not collect configuration field ", (Object)fieldName);
                    aCRALog.w(string2, string, e);
                }
            }
            catch (IllegalArgumentException e) {
                boolean $i$f$error = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Error while inspecting device configuration: ";
                aCRALog.e(string2, string, e);
            }
            catch (IllegalAccessException e) {
                boolean $i$f$error = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Error while inspecting device configuration: ";
                aCRALog.e(string2, string, e);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Prefix, SparseArray<String>> getValueArrays() {
        void $this$mapTo$iv$iv;
        Prefix[] prefixArray;
        Object $this$firstOrNull$iv;
        void $this$groupByTo$iv$iv;
        boolean bl;
        Iterable $this$filterTo$iv$iv;
        Field[] fieldArray = Configuration.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"Configuration::class.java.fields");
        Object[] $this$filter$iv = fieldArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Field it = (Field)element$iv$iv;
            bl = false;
            if (!(Modifier.isStatic(it.getModifiers()) && Modifier.isFinal(it.getModifiers()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            Prefix prefix;
            block11: {
                Field field = (Field)t;
                boolean bl2 = false;
                $this$firstOrNull$iv = Prefix.values();
                boolean $i$f$firstOrNull = false;
                prefixArray = $this$firstOrNull$iv;
                int bl3 = prefixArray.length;
                for (int i = 0; i < bl3; ++i) {
                    Prefix element$iv;
                    Prefix it = element$iv = prefixArray[i];
                    boolean bl22 = false;
                    String string = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                    if (!StringsKt.startsWith$default((String)string, (String)it.getText(), (boolean)false, (int)2, null)) continue;
                    prefix = element$iv;
                    break block11;
                }
                prefix = null;
            }
            Prefix key$iv$iv = prefix;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Object $this$filterKeys$iv = destination$iv$iv;
        boolean $i$f$filterKeys = false;
        Map result$iv = new LinkedHashMap();
        destination$iv$iv = $this$filterKeys$iv;
        $i$f$groupByTo = false;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            Prefix it = (Prefix)((Object)entry.getKey());
            boolean bl4 = false;
            if (!(it != null)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv;
        boolean bl5 = false;
        for (Map.Entry item$iv$iv : iterator.entrySet()) {
            void $this$mapNotNullToSparseArray$iv;
            void $dstr$prefix$fields;
            $this$firstOrNull$iv = item$iv$iv;
            Object object = destination$iv$iv;
            bl = false;
            prefixArray = $dstr$prefix$fields;
            boolean iterable = false;
            Prefix prefix = (Prefix)((Object)prefixArray.getKey());
            Iterable iterable2 = $dstr$prefix$fields;
            boolean element$iv = false;
            List fields = (List)iterable2.getValue();
            Intrinsics.checkNotNull((Object)((Object)prefix));
            iterable2 = fields;
            Prefix prefix2 = prefix;
            boolean $i$f$mapNotNullToSparseArray = false;
            SparseArray destination$iv = new SparseArray();
            void $this$forEach$iv$iv = $this$mapNotNullToSparseArray$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair pair;
                block12: {
                    String string;
                    ACRALog aCRALog;
                    String string2;
                    boolean $i$f$warn;
                    Pair pair2;
                    Object element$iv$iv;
                    Object element$iv2 = element$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    Field it = (Field)element$iv2;
                    boolean bl52 = false;
                    try {
                        pair2 = TuplesKt.to((Object)it.getInt(null), (Object)it.getName());
                        break block12;
                    }
                    catch (IllegalArgumentException e) {
                        $i$f$warn = false;
                        string2 = ACRA.LOG_TAG;
                        aCRALog = ACRA.log;
                        boolean bl6 = false;
                        string = "Error while inspecting device configuration: ";
                        aCRALog.w(string2, string, e);
                    }
                    catch (IllegalAccessException e) {
                        $i$f$warn = false;
                        string2 = ACRA.LOG_TAG;
                        aCRALog = ACRA.log;
                        boolean bl7 = false;
                        string = "Error while inspecting device configuration: ";
                        aCRALog.w(string2, string, e);
                    }
                    pair2 = pair = null;
                }
                if (pair == null) continue;
                Pair pair3 = pair;
                boolean bl6 = false;
                boolean bl7 = false;
                Pair $dstr$key$value$iv = pair3;
                boolean bl10 = false;
                int key$iv = ((Number)$dstr$key$value$iv.component1()).intValue();
                Object value$iv = $dstr$key$value$iv.component2();
                destination$iv.put(key$iv, value$iv);
            }
            SparseArray sparseArray = destination$iv;
            Pair pair = TuplesKt.to((Object)((Object)prefix2), (Object)sparseArray);
            object.add(pair);
        }
        return MapsKt.withDefaultMutable((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv), (Map)new EnumMap(Prefix.class)), (Function1)getValueArrays.5.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Object getFieldValueName(Map<Prefix, ? extends SparseArray<String>> valueArrays, Configuration conf, Field f) throws IllegalAccessException {
        SparseArray sparseArray;
        String string;
        Object object;
        block17: {
            Object object2;
            String fieldName = f.getName();
            if (fieldName != null) {
                int n = -1;
                switch (fieldName.hashCode()) {
                    case -1896438090: {
                        if (!fieldName.equals(FIELD_SCREENLAYOUT)) break;
                        n = 1;
                        break;
                    }
                    case 108258: {
                        if (!fieldName.equals(FIELD_MNC)) break;
                        n = 2;
                        break;
                    }
                    case -845983145: {
                        if (!fieldName.equals(FIELD_UIMODE)) break;
                        n = 3;
                        break;
                    }
                    case 107917: {
                        if (!fieldName.equals(FIELD_MCC)) break;
                        n = 2;
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        object = f.getInt(conf);
                        return object;
                    }
                    case 3: {
                        object = this.activeFlags((SparseArray<String>)((SparseArray)MapsKt.getValue(valueArrays, (Object)((Object)Prefix.UI_MODE))), f.getInt(conf));
                        return object;
                    }
                    case 1: {
                        object = this.activeFlags((SparseArray<String>)((SparseArray)MapsKt.getValue(valueArrays, (Object)((Object)Prefix.SCREENLAYOUT))), f.getInt(conf));
                        return object;
                    }
                }
            }
            Prefix[] $this$firstOrNull$iv = Prefix.values();
            boolean $i$f$firstOrNull = false;
            Prefix[] prefixArray = $this$firstOrNull$iv;
            int n = prefixArray.length;
            for (int i = 0; i < n; ++i) {
                Prefix element$iv;
                Prefix it = element$iv = prefixArray[i];
                boolean bl = false;
                String string2 = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
                String string3 = fieldName;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                boolean bl2 = false;
                String string4 = string3;
                boolean bl3 = false;
                String string5 = string4.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
                if (!Intrinsics.areEqual((Object)string2, (Object)Intrinsics.stringPlus((String)string5, (Object)"_"))) continue;
                object2 = element$iv;
                break block17;
            }
            object2 = string = null;
        }
        if (string == null) {
            sparseArray = null;
        } else {
            String string6 = string;
            boolean bl = false;
            boolean bl4 = false;
            String it = string6;
            boolean bl5 = false;
            sparseArray = (SparseArray)MapsKt.getValue(valueArrays, it);
        }
        SparseArray sparseArray2 = sparseArray;
        if (sparseArray2 == null) {
            return f.getInt(conf);
        }
        SparseArray values = sparseArray2;
        string = (String)values.get(f.getInt(conf));
        if (string == null) {
            return f.getInt(conf);
        }
        String value = string;
        object = value;
        return object;
    }

    private final String activeFlags(SparseArray<String> valueNames, int bitfield) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        int n2 = valueNames.size();
        if (n < n2) {
            do {
                int value;
                int i = n++;
                int maskValue = valueNames.keyAt(i);
                Object object = valueNames.get(maskValue);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueNames[maskValue]");
                if (!StringsKt.endsWith$default((String)((String)object), (String)SUFFIX_MASK, (boolean)false, (int)2, null) || (value = bitfield & maskValue) <= 0) continue;
                CharSequence charSequence = result;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    result.append('+');
                }
                result.append((String)valueNames.get(value));
            } while (n < n2);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final JSONObject collectConfiguration(Context context) {
        Configuration configuration;
        try {
            configuration = context.getResources().getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"context.resources.configuration");
            configuration = this.configToJson(configuration);
        }
        catch (RuntimeException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = Intrinsics.stringPlus((String)"Couldn't retrieve CrashConfiguration for : ", (Object)context.getPackageName());
            aCRALog.w(string, string2, e);
            configuration = null;
        }
        return configuration;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/acra/collector/ConfigurationCollector$Prefix;", "", "text", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getText", "()Ljava/lang/String;", "UI_MODE", "TOUCHSCREEN", "SCREENLAYOUT", "ORIENTATION", "NAVIGATIONHIDDEN", "NAVIGATION", "KEYBOARDHIDDEN", "KEYBOARD", "HARDKEYBOARDHIDDEN", "acra-core_release"})
    public static final class Prefix
    extends Enum<Prefix> {
        @NotNull
        private final String text;
        public static final /* enum */ Prefix UI_MODE = new Prefix("UI_MODE_");
        public static final /* enum */ Prefix TOUCHSCREEN = new Prefix("TOUCHSCREEN_");
        public static final /* enum */ Prefix SCREENLAYOUT = new Prefix("SCREENLAYOUT_");
        public static final /* enum */ Prefix ORIENTATION = new Prefix("ORIENTATION_");
        public static final /* enum */ Prefix NAVIGATIONHIDDEN = new Prefix("NAVIGATIONHIDDEN_");
        public static final /* enum */ Prefix NAVIGATION = new Prefix("NAVIGATION_");
        public static final /* enum */ Prefix KEYBOARDHIDDEN = new Prefix("KEYBOARDHIDDEN_");
        public static final /* enum */ Prefix KEYBOARD = new Prefix("KEYBOARD_");
        public static final /* enum */ Prefix HARDKEYBOARDHIDDEN = new Prefix("HARDKEYBOARDHIDDEN_");
        private static final /* synthetic */ Prefix[] $VALUES;

        private Prefix(String text) {
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public static Prefix[] values() {
            Prefix[] prefixArray = $VALUES;
            return Arrays.copyOf(prefixArray, prefixArray.length);
        }

        public static Prefix valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Prefix.class, value);
        }

        static {
            $VALUES = prefixArray = new Prefix[]{Prefix.UI_MODE, Prefix.TOUCHSCREEN, Prefix.SCREENLAYOUT, Prefix.ORIENTATION, Prefix.NAVIGATIONHIDDEN, Prefix.NAVIGATION, Prefix.KEYBOARDHIDDEN, Prefix.KEYBOARD, Prefix.HARDKEYBOARDHIDDEN};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/acra/collector/ConfigurationCollector$Companion;", "", "()V", "FIELD_MCC", "", "FIELD_MNC", "FIELD_SCREENLAYOUT", "FIELD_UIMODE", "SUFFIX_MASK", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportField.values().length];
            nArray[ReportField.INITIAL_CONFIGURATION.ordinal()] = 1;
            nArray[ReportField.CRASH_CONFIGURATION.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

