/*
 * Decompiled with CFR 0.152.
 */
package org.acra.startup;

import android.content.Context;
import android.os.Handler;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.interaction.ReportInteractionExecutor;
import org.acra.scheduler.SchedulerStarter;
import org.acra.startup.Report;
import org.acra.startup.StartupProcessor;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/acra/startup/StartupProcessorExecutor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "schedulerStarter", "Lorg/acra/scheduler/SchedulerStarter;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;Lorg/acra/scheduler/SchedulerStarter;)V", "fileNameParser", "Lorg/acra/file/CrashReportFileNameParser;", "reportLocator", "Lorg/acra/file/ReportLocator;", "processReports", "", "isAcraEnabled", "", "acra-core_release"})
public final class StartupProcessorExecutor {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final SchedulerStarter schedulerStarter;
    @NotNull
    private final ReportLocator reportLocator;
    @NotNull
    private final CrashReportFileNameParser fileNameParser;

    public StartupProcessorExecutor(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull SchedulerStarter schedulerStarter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)schedulerStarter, (String)"schedulerStarter");
        this.context = context;
        this.config = config;
        this.schedulerStarter = schedulerStarter;
        this.reportLocator = new ReportLocator(this.context);
        this.fileNameParser = new CrashReportFileNameParser();
    }

    public final void processReports(boolean isAcraEnabled) {
        Calendar now = Calendar.getInstance();
        new Handler(this.context.getMainLooper()).post(() -> StartupProcessorExecutor.processReports$lambda-5(this, now, isAcraEnabled));
    }

    /*
     * WARNING - void declaration
     */
    private static final void processReports$lambda-5$lambda-4(StartupProcessorExecutor this$0, Calendar $now, boolean $isAcraEnabled) {
        void $this$forEach$iv;
        Iterable $this$loadEnabled$iv;
        Object object;
        Object object2;
        File it;
        Object object3;
        File[] $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object $this$map$iv = this$0.reportLocator.getUnapprovedReports();
        boolean $i$f$map = false;
        File[] fileArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((File[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (File item$iv$iv : $this$mapTo$iv$iv) {
            void var13_21 = item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object2 = new Report(it, false);
            object3.add(object2);
        }
        $this$map$iv = this$0.reportLocator.getApprovedReports();
        object3 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(((File[])$this$map$iv).length);
        $i$f$mapTo = false;
        File[] fileArray2 = $this$mapTo$iv$iv;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File item$iv$iv;
            it = item$iv$iv = fileArray2[i];
            object2 = destination$iv$iv;
            boolean bl = false;
            object = new Report(it, true);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        List reports = CollectionsKt.plus((Collection)object3, (Iterable)((Iterable)object2));
        $this$map$iv = this$0.config.getPluginLoader();
        CoreConfiguration config$iv = this$0.config;
        boolean $i$f$loadEnabled = false;
        $this$loadEnabled$iv = $this$loadEnabled$iv.loadEnabled(config$iv, StartupProcessor.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StartupProcessor it2 = (StartupProcessor)element$iv;
            boolean bl = false;
            it2.processReports(this$0.context, this$0.config, reports);
        }
        boolean send = false;
        for (Report report : reports) {
            Object element$iv;
            CrashReportFileNameParser crashReportFileNameParser = this$0.fileNameParser;
            element$iv = report.getFile().getName();
            Intrinsics.checkNotNullExpressionValue(element$iv, (String)"report.file.name");
            if (!crashReportFileNameParser.getTimestamp((String)element$iv).before($now)) continue;
            if (report.getDelete()) {
                if (report.getFile().delete()) continue;
                boolean $i$f$warn = false;
                object2 = ACRA.LOG_TAG;
                object3 = ACRA.log;
                boolean bl = false;
                object = Intrinsics.stringPlus((String)"Could not delete report ", (Object)report.getFile());
                object3.w((String)object2, (String)object);
                continue;
            }
            if (report.getApproved()) {
                send = true;
                continue;
            }
            if (!report.getApprove() || !$isAcraEnabled) continue;
            new ReportInteractionExecutor(this$0.context, this$0.config).performInteractions(report.getFile());
        }
        if (send && $isAcraEnabled) {
            this$0.schedulerStarter.scheduleReports(null, false);
        }
    }

    private static final void processReports$lambda-5(StartupProcessorExecutor this$0, Calendar $now, boolean $isAcraEnabled) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        new Thread(() -> StartupProcessorExecutor.processReports$lambda-5$lambda-4(this$0, $now, $isAcraEnabled)).start();
    }
}

